package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum DestoryUnitExceptionEnum implements IExceptionEnum {
    /**
     * 删除时未选中需要删除的销毁/报废收物单位
     */
    DESTORYUNIT_NOT_CHOOSE(CommonConstant.DEFAULT_USER_ERROR_CODE,"删除时未选中需要删除的销毁/报废收物单位"),
    /**
     * 销毁、报废收物单位不存在
     */
    DESTORYUNIT_NOT_EXIST(CommonConstant.DEFAULT_CORE_ERROR_CODE,"销毁、报废收物单位不存在"),
    /**
     * 销毁、报废收物单位已存在
     */
    DESTORYUNIT_IS_EXIST(CommonConstant.DEFAULT_CORE_ERROR_CODE,"销毁、报废收物单位已存在"),;
    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    DestoryUnitExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
