package com.junmp.junmpProcess.listener;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.junmp.junmpProcess.dto.json.ChildNode;
import com.junmp.junmpProcess.utils.RabbitMQUtils2;
//import com.rabbitmq.client.Channel;
//import com.rabbitmq.client.Connection;
import com.junmp.jyzb.api.bean.req.UpdateOrderReq;
import com.junmp.jyzb.service.OrderMainService;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.MessageProperties;
import lombok.SneakyThrows;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEntityEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.impl.event.FlowableEntityEventImpl;
import org.flowable.engine.delegate.event.AbstractFlowableEngineEventListener;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;


@Component
    public class GlobalEndListener extends AbstractFlowableEngineEventListener {
        protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    public OrderMainService orderMainService;
        @SneakyThrows
        @Override
        protected void processCompleted(FlowableEngineEntityEvent event) {
            if (event.getType() == FlowableEngineEventType.PROCESS_COMPLETED) {
                // 获取流程实例ID
                String processInstanceId = event.getProcessInstanceId();

                // 获取流程定义ID
                String processDefinitionId = event.getProcessDefinitionId();

                // 获取流程实例关联的变量
                Map<String, Object> processVariables = getProcessVariables(processInstanceId);

                // 获取单据类型
                String documentType = (String) processVariables.get("documentType");
                UpdateOrderReq updateOrderReq = JSONObject.parseObject(documentType, new TypeReference<UpdateOrderReq>() {
                });
                // 获取单据类型
                String orderReq = (String) processVariables.get("orderReq");
                // 根据单据类型执行不同的操作
                if ("equipment".equals(documentType)) {
                    // 执行装备相关操作
                    orderMainService.AddOrder(updateOrderReq);
                } else if ("personnel".equals(documentType)) {
                    // 执行人员相关操作
                    // ...
                }

            }
        }

    // 获取流程实例关联的变量
    private Map<String, Object> getProcessVariables(String processInstanceId) {
        // 根据 processInstanceId 获取流程实例关联的变量
        // 这里需要根据你的业务逻辑来实现获取变量的方法
        // 返回一个包含流程变量的 Map
        return  null;
    }
    }

