package com.junmp.jyzb.task;

import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.junmp.jyzb.entity.OrderMain;
import com.junmp.jyzb.service.OrderMainService;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.dict.entity.SysDictItem;
import com.junmp.v2.dict.service.SysDictItemService;
import com.junmp.v2.job.api.JobAction;
import com.junmp.v2.message.api.MessageApi;
import com.junmp.v2.message.api.bean.req.MessageReq;
import com.junmp.v2.message.api.bean.req.MessageSendReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author lxh
 * @description  超期未归还消息提醒
 * @since 2023/9/1 10:50
 * @param
 * @return
 **/
@Slf4j
@Component
public class InvOverDueMsg implements JobAction {

    @Resource
    private OrderMainService orderMainService;
    @Resource
    private MessageApi messageApi;

    @Resource
    private SysDictItemService sysDictItemService;

    @Override
    public void action() {
        //获取超期物资
        //先查询出 出入库单据为借用单的数据
        LambdaQueryWrapper<OrderMain> wrapper = new LambdaQueryWrapper<OrderMain>()
                .eq(OrderMain::getBussinessType, "borrow")
                .eq(OrderMain::getOrderType,"out");
        int pageSize =1000;
        int currentPage=1;
        long termCount= orderMainService.count(wrapper);
        List<OrderMain> list=new ArrayList<>();
        if (termCount>0) {
            // 分页查询
            while ((currentPage - 1) * pageSize < termCount) {
                List<OrderMain> orderMainList = processPageData(currentPage, pageSize);
                currentPage++;
                list.addAll(orderMainList);
            }
        }
        //将消息进行推送
        for (OrderMain orderMain:list) {
            MessageSendReq sendReq = new MessageSendReq();
            sendReq.setSendUserId("1000");
            //接收用户id先写死，后面再修改
            sendReq.setReceiveUserIds("1000");
            sendReq.setMsgTitle("物资超期");
            //设置业务类型
            SysDictItem one = sysDictItemService.getOne(new LambdaQueryWrapper<SysDictItem>()
                    .eq(SysDictItem::getDictItemId, "1698969778501099522"));
            sendReq.setBizType(one.getItemValue());
            sendReq.setMsgContent("单据id为："+orderMain.getId()+"的物资超期，请及时查看提醒");
            sendReq.setPriority("0");
            sendReq.setSendTime(DateTime.now());
            messageApi.sendMessage(sendReq);
        }
        messageApi.queryCount(new MessageReq());
        /*推送发送未读数量*/
        //添加需要将消息推送的userid，先写死，可以查询数据库表动态设置userid；
        List<Long> userIdList=new ArrayList<>();
        userIdList.add(1000L);
        for(Long userId :userIdList){
            MessageReq req1 = new MessageReq();
            req1.setReadFlag(0);
            req1.setReceiveUserId(userId);
            Integer count1 = messageApi.queryCount(req1);
            messageApi.pushMsgToUser(String.valueOf(userId),count1);
        }

    }

    // 处理每页数据
    private List<OrderMain> processPageData(long pageSize, long currentPage) {
        //获取对应的借用单据数据
        Date currentDateTime = DateTimeUtil.getCurrentDateTime();
        LambdaQueryWrapper<OrderMain> wrapper = new LambdaQueryWrapper<OrderMain>()
                .eq(OrderMain::getBussinessType, "borrow")
                .eq(OrderMain::getOrderType,"out")
                .lt(OrderMain::getReturnDate,currentDateTime);
        List<OrderMain> records = orderMainService.page(PageFactory.getDefaultPage(pageSize, currentPage),wrapper).getRecords();
        return records;
    }
}
