package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.StocktakeDto;
import com.junmp.jyzb.api.bean.query.StocktakeReq;
import com.junmp.jyzb.api.bean.req.UpdateStocktakeReq;
import com.junmp.jyzb.api.exception.enums.OrderExceptionEnum;
import com.junmp.jyzb.entity.OrderNum;
import com.junmp.jyzb.entity.Stocktake;
import com.junmp.jyzb.service.OrderNumService;
import com.junmp.jyzb.service.StocktakeService;
import com.junmp.jyzb.mapper.StocktakeMapper;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import com.junmp.v2.dict.entity.SysDictItem;
import com.junmp.v2.dict.service.SysDictItemService;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;

/**
* @author lxh专属坐骑
* @description 针对表【bussiness_stocktake】的数据库操作Service实现
* @createDate 2023-09-20 14:48:50
*/
@Service
public class StocktakeServiceImpl extends ServiceImpl<StocktakeMapper, Stocktake>
    implements StocktakeService{

    @Resource
    private SysDictItemService sysDictItemService;

    @Resource
    private OrderNumService orderNumService;

    //盘库申请
    @Override
    @Transactional(rollbackFor = Exception.class)
    public String AddStocktakeOrder(UpdateStocktakeReq req) {
        Stocktake stocktake = new Stocktake();
        BeanPlusUtil.copyProperties(req,stocktake);
        //设置单号
        OrderNum orderNum = setOrderCode(req);
        String codeValue=String.format("%04d",orderNum.getNum());
        stocktake.setOrderCode(orderNum.getBussinessType()+"-"+orderNum.getYear()+"-"+orderNum.getMonth()+"-"+orderNum.getDay()+"-"+codeValue);
        //如果盘库类型为1：根据货架进行盘点，判断参数排列行是否进行传递，如果传递则需要进行一个参数拼接
        String shelfLocation="";
        if (ObjectUtil.isNotNull(req.getShelfRanges()) && !req.getShelfRanges().toString().trim().isEmpty()) {
            shelfLocation += req.getShelfRanges()+"/";
            stocktake.setShelfLocation(shelfLocation);
        }

        if (ObjectUtil.isNotNull(req.getShelfColumns()) && !req.getShelfColumns().toString().trim().isEmpty()) {
            shelfLocation += req.getShelfColumns()+"/";
            stocktake.setShelfLocation(shelfLocation);
        }

        if (ObjectUtil.isNotNull(req.getShelfRows())  && !req.getShelfRows().toString().trim().isEmpty()) {
            shelfLocation += req.getShelfRows();
            stocktake.setShelfLocation(shelfLocation);
        }
        stocktake.setCreateTime(DateTimeUtil.getCurrentDateTime());
        stocktake.setApplyTime(DateTimeUtil.getCurrentDateTime());
        this.save(stocktake);
        return stocktake.getId();
    }

    //盘库单据查询
    @Override
    public PageResult<Stocktake> ShowStocktakeOrderPage(StocktakeReq req) {
        LambdaQueryWrapper<Stocktake> eq = new LambdaQueryWrapper<Stocktake>()
                .eq(ObjectUtil.isNotNull(req.getOrgId()),Stocktake::getOrgId,req.getOrgId())
                .eq(ObjectUtil.isNotNull(req.getLocationId()),Stocktake::getLocationId,req.getLocationId())
                .ge(ObjectUtil.isNotNull(req.getStartTime()),Stocktake::getCreateTime,req.getStartTime())
                .le(ObjectUtil.isNotNull(req.getEndTime()),Stocktake::getCreateTime,req.getEndTime());
        Page<Stocktake> page = page(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()), eq);
        return PageResultFactory.createPageResult(page);
    }


    //更新盘库单据（未进入工作流时才能进行修改）
    @Override
    public boolean UpdateStocktakeOrder(UpdateStocktakeReq req) {
        if (!req.getExamineState().equals("none"))
        {
            throw new ServiceException(OrderExceptionEnum.ORDER_CAN_NOT_UPDATE);
        }
        Stocktake stocktake = getById(req.getId());
        BeanPlusUtil.copyProperties(req,stocktake);
        stocktake.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        return updateById(stocktake);
    }


    /**
     * 设置单据单号
     * @param req
     */
    public OrderNum setOrderCode(UpdateStocktakeReq req){
        //设置采购单号，需要先判断该组织机构的采购单号是否存在，如果存在则将数量进行增加，如果不存在则新增一条对应的数据
        OrderNum orderNum = new OrderNum();
        //获取年,月，日，获取组织机构id，获取业务类型
        orderNum.setYear(LocalDateTime.now().getYear());
        orderNum.setMonth(LocalDateTime.now().getMonth().getValue());
        orderNum.setDay(LocalDateTime.now().getDayOfMonth());
        orderNum.setBussinessType(req.getBussinessType());
        orderNum.setOrgId(req.getOrgId());
        //将业务类型转为中文简写
        String itemValue = sysDictItemService.getOne(new LambdaQueryWrapper<SysDictItem>()
                .eq(SysDictItem::getItemText, req.getBussinessType())).getItemValue();
        orderNum.setBussinessType(itemValue);
        OrderNum one = orderNumService.getOne(new LambdaQueryWrapper<OrderNum>()
                .eq(OrderNum::getOrgId, orderNum.getOrgId())
                .eq(OrderNum::getBussinessType, orderNum.getBussinessType())
                .eq(OrderNum::getYear, orderNum.getYear())
                .eq(OrderNum::getMonth, orderNum.getMonth())
                .eq(OrderNum::getDay, orderNum.getDay()));
        //设置num的数量
        if (ObjectUtil.isNull(one)){
            orderNum.setNum(1);
            orderNumService.save(orderNum);
            return orderNum;
        }else {
            one.setNum(one.getNum()+1);
            orderNumService.updateById(one);
            return one;
        }
    }
}




