package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.query.ProductSkuReq;
import com.junmp.jyzb.api.exception.JYZBAppException;
import com.junmp.jyzb.api.exception.enums.ProductExceptionEnum;
import com.junmp.jyzb.api.util.GenCodeUtil;
import com.junmp.jyzb.entity.Product;
import com.junmp.jyzb.entity.ProductSku;
import com.junmp.jyzb.mapper.ProductSkuMapper;
import com.junmp.jyzb.service.ProductService;
import com.junmp.jyzb.service.ProductSkuService;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/7/29 16:26
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Slf4j
@Service
public class ProductSkuServiceImpl extends ServiceImpl<ProductSkuMapper, ProductSku> implements ProductSkuService {

    @Resource
    private ProductService productService;

    @Override
    public boolean addProductSku(ProductSkuReq req) {
        ProductSku entity = new ProductSku();
        BeanPlusUtil.copyProperties(req, entity);

        Integer maxSn = baseMapper.getMaxSn(req.getProductId());
        //1-获取当前序号
        Integer sn = maxSn + 1;
        entity.setSn(sn);
        //2- 设置号型编号
        String hxCode = GenCodeUtil.genSpecCode(sn);
        entity.setSpecCode(hxCode);

        //3-设置SKU代码
        Product product = productService.getById(req.getProductId());
        if (ObjectUtil.isNotNull(product)) {
            entity.setSkuCode(GenCodeUtil.genSkuCode(product.getProductCode(), hxCode));
            return this.save(entity);
        } else {
            log.warn(StrUtil.format("该产品不存在,编号为：{}", req.getProductId()));
            throw new JYZBAppException(ProductExceptionEnum.PRODUCT_NOT_EXIST);
        }
    }

    @Override
    public boolean editProductSku(ProductSkuReq req) {
        ProductSku entity = queryProductSku(req);
        BeanPlusUtil.copyProperties(req, entity);
        return this.updateById(entity);
    }

    @Override
    public boolean del(ProductSkuReq req) {
        ProductSku sku = queryProductSku(req);

        return removeById(sku.getSpecId());
    }

    @Override
    public boolean delByProductId(Long productId) {
        return baseMapper.delByProductId(productId);
    }

    @Override
    public List<ProductSku> findList(ProductSkuReq req) {
        LambdaQueryWrapper<ProductSku> wp = createWrapper(req);
        return this.list(wp);
    }

    @Override
    public PageResult<ProductSku> findPage(ProductSkuReq req) {
        LambdaQueryWrapper<ProductSku> wrapper = createWrapper(req);
        Page<ProductSku> page = this.page(PageFactory.getDefaultPage(req.getPageNo(),req.getPageSize()), wrapper);
        return PageResultFactory.createPageResult(page);
    }


    private ProductSku queryProductSku(ProductSkuReq req) {
        ProductSku app = this.getById(req.getSpecId());
        if (ObjectUtil.isNull(app)) {
            throw new ServiceException(ProductExceptionEnum.PRODUCT_SKU_NOT_EXIST);
        }
        return app;
    }


    private LambdaQueryWrapper<ProductSku> createWrapper(ProductSkuReq req) {
        LambdaQueryWrapper<ProductSku> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据业务编码查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getSkuCode()), ProductSku::getSkuCode, req.getSkuCode());
        //根据企业名称模糊查询
        wrapper.eq(ObjectUtil.isNotEmpty(req.getProductId()), ProductSku::getProductId, req.getProductId());
        wrapper.orderByDesc(ProductSku::getSn);
        return wrapper;
    }
}
