package com.junmp.jyzb.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.LogDetailDto;
import com.junmp.jyzb.api.bean.dto.LogSummaryDto;
import com.junmp.jyzb.entity.LogDetail;
import com.junmp.jyzb.entity.LogSummary;
import com.junmp.jyzb.mapper.LogSummaryMapper;
import com.junmp.jyzb.service.LogDetailService;
import com.junmp.jyzb.service.LogSummaryService;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;

import java.util.ArrayList;
import java.util.List;

@Service
public class LogSummaryServiceImpl extends ServiceImpl<LogSummaryMapper, LogSummary> implements LogSummaryService {
    @Resource
    private LogDetailService logDetailService;
    @Override
    public List<LogSummaryDto> getLogs() {
        List<LogSummary> list = list(new LambdaQueryWrapper<LogSummary>().orderByDesc(LogSummary::getCreateTime));
        List<LogSummaryDto> logSummaryDtoList=new ArrayList<>();
        List<LogDetailDto> logDetailDtoList=new ArrayList<>();
        for (LogSummary logSummary:list) {
            LogSummaryDto logSummaryDto = new LogSummaryDto();
            BeanPlusUtil.copyProperties(logSummary,logSummaryDto);
            List<LogDetail> list1 = logDetailService.list(new LambdaQueryWrapper<LogDetail>()
                    .eq(LogDetail::getSummaryId, logSummary.getId()));
            for (LogDetail logDetail:list1) {
                LogDetailDto logDetailDto = new LogDetailDto();
                BeanPlusUtil.copyProperties(logDetail,logDetailDto);
                logDetailDtoList.add(logDetailDto);
            }
            logSummaryDto.setEquipmentList(logDetailDtoList);
            logSummaryDtoList.add(logSummaryDto);
        }
        return logSummaryDtoList;
    }
}
