package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.InventorySumDto;
import com.junmp.jyzb.api.bean.query.InventorySumReq;
import com.junmp.jyzb.entity.EquipmentType;
import com.junmp.jyzb.entity.Inventory;
import com.junmp.jyzb.entity.InventorySummary;
import com.junmp.jyzb.service.*;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import org.springframework.stereotype.Service;
import com.junmp.jyzb.mapper.InventorySummaryMapper;
import org.springframework.web.bind.annotation.RequestBody;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class InventorySummaryServiceImpl  extends ServiceImpl<InventorySummaryMapper, InventorySummary> implements InventorySummaryService {

    @Resource
    private PubOrgService pubOrgService;

    @Resource
    private OrderMainService orderMainService;

    @Resource
    private InventoryService inventoryService;

    @Resource
    private InventorySummaryMapper inventorySummaryMapper;

    @Resource
    private EquipmentTypeService equipmentTypeService;

    //根据条件查询库存汇总信息
    @Override
    public PageResult<InventorySummary> getEquipmentInfo(InventorySumReq req) {
        //当没有参数传递的时候默认查询全部，但是如果传递了条件，根据条件查询并且如果是根据id进行查询，则需要判断该id是否存在
        //判断组织机构是否存在
        if (ObjectUtil.isNotNull(req.getOrgId())){
            pubOrgService.PubOrgExist(req.getOrgId());
        }
        LambdaQueryWrapper<InventorySummary> wp = createWrapper(req);//取出仓库中总数并计算
        long size = list(wp).size();
        Page<InventorySummary> sumList= this.page(PageFactory.getDefaultPage(req.getPageNo(),req.getPageSize()),wp);
        List<InventorySummary> records = sumList.getRecords();

        List<InventorySummary> collect = records.stream().map(data -> {
            Inventory inventory = inventoryService.list(new LambdaQueryWrapper<Inventory>()
                    .eq(Inventory::getOrgId, data.getOrgId())
                    .eq(Inventory::getSizeId, data.getSizeId())
                    .eq(Inventory::getTypeId, data.getTypeId())).get(0);
            data.setWarrantyPeriod(inventory.getWarrantyPeriod());
            data.setMaintenancePeriod(inventory.getMaintenancePeriod());
            String photo = equipmentTypeService.getOne(new LambdaQueryWrapper<EquipmentType>().eq(EquipmentType::getId,inventory.getTypeId())).getPhoto();
            data.setPhoto(photo);
            return data;
        }).collect(Collectors.toList());
        Page<InventorySummary> page1 = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        page1.setRecords(collect);
        page1.setTotal(size);
        return PageResultFactory.createPageResult(page1);
    }

    /**
     * 用于出库单中的装备选择
     * @return
     */
    @Override
    public List<InventorySumDto> GetInventorySumInfo(InventorySumReq req) {

        return inventorySummaryMapper.GetInventorySumInfo(req);
    }

    private LambdaQueryWrapper<InventorySummary> createWrapper(InventorySumReq req) {
        LambdaQueryWrapper<InventorySummary> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据组织机构号查询
        wrapper.eq(ObjectUtil.isNotEmpty(req.getOrgId()), InventorySummary::getOrgId, req.getOrgId());
        //根据组织机构名模糊查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getOrgName()), InventorySummary::getOrgName, req.getOrgName());
        //位置id（单警柜/仓库）
        wrapper.eq(ObjectUtil.isNotEmpty(req.getLocationId()), InventorySummary::getLocationId, req.getLocationId());
        //位置信息
        wrapper.like(ObjectUtil.isNotEmpty(req.getLocationName()), InventorySummary::getLocationName, req.getLocationName());
        //装备类别名称
        wrapper.like(ObjectUtil.isNotEmpty(req.getTypeName()), InventorySummary::getTypeName, req.getTypeName());
        //根据类别
        wrapper.eq(ObjectUtil.isNotEmpty(req.getTypeId()), InventorySummary::getTypeId, req.getTypeId());
        //型号名称
        wrapper.like(ObjectUtil.isNotEmpty(req.getSizeName()), InventorySummary::getSizeName, req.getSizeName());
        //号型
        wrapper.eq(ObjectUtil.isNotEmpty(req.getSizeId()), InventorySummary::getSizeId, req.getSizeId());
        wrapper.orderByDesc(InventorySummary::getTypeId);
        wrapper.orderByDesc(InventorySummary::getSizeId);

        return wrapper;
    }
}
