package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.query.CabinetReq;
import com.junmp.jyzb.api.bean.req.UpdateCabinetBoxReq;
import com.junmp.jyzb.entity.Cabinet;
import com.junmp.jyzb.entity.CabinetBox;
import com.junmp.jyzb.api.exception.enums.CabinetBoxExceptionEnum;
import com.junmp.jyzb.api.exception.enums.CabinetExceptionEnum;
import com.junmp.jyzb.mapper.CabinetBoxMapper;
import com.junmp.jyzb.mapper.PoliceFingerMapper;
import com.junmp.jyzb.mapper.PolicemanMapper;
import com.junmp.jyzb.service.CabinetBoxService;
import com.junmp.jyzb.service.CabinetService;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@Service
public class CabinetBoxServiceImpl extends ServiceImpl<CabinetBoxMapper, CabinetBox> implements CabinetBoxService {


    @Resource
    private CabinetService cabinetService;



    //添加箱门信息
    @Override
    @Transactional(rollbackFor = Exception.class)
    public String AddBoxInfo(UpdateCabinetBoxReq req) {
        Cabinet cabinet = cabinetService.getOne(new LambdaQueryWrapper<Cabinet>()
                .eq(Cabinet::getCabinetNum, req.getCabinetNum()));
        if (ObjectUtil.isNull(cabinet)){
            throw new ServiceException(CabinetExceptionEnum.CABINET_ISNOT_EXISTS);
        }
        CabinetBox one = getOne(new LambdaQueryWrapper<CabinetBox>()
                .eq(CabinetBox::getCabinetId, cabinet.getId())
                .eq(CabinetBox::getId,req.getId()));
        if (ObjectUtil.isNotNull(one)){
            throw new ServiceException(CabinetBoxExceptionEnum.CABINETBOX_IS_EXISTS);
        }
        CabinetBoxExist(req.getId());
        CabinetBox cabinetBox = new CabinetBox();
        BeanPlusUtil.copyProperties(req,cabinetBox);
        //添加单警柜箱门信息默认状态为0正常
        cabinetBox.setState(0);
        cabinetBox.setCabinetId(cabinet.getId());
        Integer num = cabinet.getNum();
        if (num==null){
            num=1;
            cabinet.setNum(num);
            cabinetBox.setNum(num);
        }else {
            cabinet.setNum(num+1);
            cabinetBox.setNum(num+1);
        }
        cabinetService.updateById(cabinet);
        save(cabinetBox);
        return cabinetBox.getId();
    }

    //判断箱子信息是否存在
    @Override
    public CabinetBox CabinetBoxExist(String id) {
        CabinetBox cabinetBox = getById(id);
        if (ObjectUtil.isNull(cabinetBox)) {
            throw new ServiceException(CabinetBoxExceptionEnum.CABINETBOX_ISNOT_EXISTS);
        }
        return cabinetBox;
    }

}
