package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.dto.*;
import com.junmp.jyzb.api.bean.query.*;

import com.junmp.jyzb.api.bean.req.BatchEditingInvsReq;
import com.junmp.jyzb.api.bean.req.EquipmentBindReq;
import com.junmp.jyzb.entity.Inventory;
import com.junmp.jyzb.entity.InventorySummary;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.db.api.page.PageResult;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public interface InventoryService extends IService<Inventory> {
    //根据装备id查询出装备的详细信息
    InventoryDto getInventoryDetail(InventoryReq msg);


    //计算更新库存汇总表信息
    boolean setInventoryMsg();


    boolean UpdateWarehouseInsNum(WarehouseReq req);

    boolean UpdateCabinetInsNum(CabinetReq req);

    boolean InventoryBind(EquipmentBindReq req);

    List<InventoryDto> GetInvInfoByEpc(InventoryReq req);

    //根据组织机构/单警柜id/仓库id查询每件装备细信的详息（返回结果是List）
    List<InventoryDto> EqsBySearchType(InventoryReq req);

    //根据组织机构/单警柜id/仓库id查询每件装备细信的详息（返回结果是page）
    PageResult<InventoryDto> EqsByTypePage(InventoryReq req);

    //查询箱门（cabinetBox下）所有装备简要信息列表（传递cabinetBoxId）
    List<EqsBriefDto> searchEqsByBoxId(CabinetBoxReq req);


    //通过货架id查询装备信息汇总
    List<InventorySummary> ShelfInventoryList(ShelfReq req);

    //根据货架id查询装备信息汇总 (page)
    PageResult<InventorySummary> ShelfInventoryPage(ShelfReq req);

    //通过货架id查询装备简要信息
    List<EqsBriefDto> ShelfInventoryDetail(InventoryReq req);
    PageResult<EqsBriefDto> ShelfInventoryPage(InventoryReq req);

    //通过区域id查询装备信息汇总(list)
    List<InventorySummary> AreaInventoryList(WarehouseAreaReq req);

    //通过区域id查询装备信息汇总(page)
    PageResult<InventorySummary> AreaInventoryPage(WarehouseAreaReq req);

    //通过装备id判断装备是否存在
    Inventory InventoryExist(String id);

    //通过单警柜箱门id获取箱门下的装备汇总信息(list)
    List<InventorySummary> EqsByCabinetBoxId(CabinetBoxReq req);

    //通过单警柜箱门id获取箱门下的装备汇总信息(page)
    PageResult<InventorySummary> EqsByCabinetBoxIdPage(CabinetBoxReq req);

    //通过组织机构id对该组织机构下的装备进行导出
    void ExportInventoryExcel(InventoryReq req);

    //获取装备的出入库记录
    List<InOutRecordsDto> getInOutRecords(InventoryReq req);

    //通过条件查询装备数量报表
    List<EqsSumDto> GetListEquipment(InventoryReq req);

    //查询箱门（cabinetBox下）所有装备简要信息列表page（传递cabinetBoxId）
    PageResult<EqsBriefDto> searchEqsByBoxIdPage(CabinetBoxReq req);

    //根据条件查询仓库下的所有装备信息
    PageResult<InventoryDto> GetDetailByTerms(InventoryReq req);

    //批量信息修改
    boolean BatchEditingInvsInfo(BatchEditingInvsReq req);
}
