package com.junmp.jyzb.rabbitmq;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.junmp.jyzb.service.OrderLogService;
import com.rabbitmq.client.Channel;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * 创建消息接收监听�
 * */
@Component
@RabbitListener(queues = "Test1Exchange") //监听的队列名 TestDirectQueue
public class DirectReceiver {
    @Resource
    private OrderLogService orderLogService;
    @RabbitHandler
    private void modelConvert(String content, Channel channel, @Header(AmqpHeaders.DELIVERY_TAG) long deliveryTag) {

        try {
//            ObjectMapper objectMapper=new ObjectMapper();
//            OrderLog orderLog = objectMapper.readValue(content, OrderLog.class);
//            // 进行消息处理和条件判断
//            orderLogService.save(orderLog);
            // 手动确认消息
            channel.basicAck(deliveryTag, false);
        } catch (Exception e) {
            // 处理消息过程中发生异常，拒绝消息并将其重新放回队列
            try {
                channel.basicNack(deliveryTag, false, true);
            } catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}
