package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @TableName bussiness_stocktake
 */
@TableName(value ="bussiness_stocktake")
@Data
public class Stocktake implements Serializable {

    /**
     * id
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 工作流
     */
    @TableField(value = "process_id")
    private String processId;

    /**
     * 单据业务类型：盘库stocktake
     */
    @TableField(value = "bussiness_type")
    private String bussinessType;

    /**
     * 单据单号
     */
    @TableField(value = "order_code")
    private String orderCode;

    /**
     * 组织机构id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 组织机构名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 仓库id
     */
    @TableField(value = "location_id")
    private String locationId;

    /**
     * 仓库名称
     */
    @TableField(value = "location_name")
    private String locationName;

    /**
     * 盘库类型（0全盘，1根据货架位置盘，2根据装备类型盘）
     */
    @TableField(value = "stocktake_type")
    private Integer stocktakeType;

    /**
     * 货架id（类型为1时特有）
     */
    @TableField(value = "shelf_id")
    private String shelfId;

    /**
     * 货架位置（类型为1时特有）
     */
    @TableField(value = "shelf_location")
    private String shelfLocation;

    /**
     * 号型id（类型为2时特有）
     */
    @TableField(value = "size_id")
    private String sizeId;

    /**
     * 号型名称（类型为2时特有）
     */
    @TableField(value = "size_name")
    private String sizeName;

    /**
     * 类型id（类型为2时特有）
     */
    @TableField(value = "type_id")
    private String typeId;

    /**
     * 类型名称（类型为2时特有）
     */
    @TableField(value = "type_name")
    private String typeName;

    /**
     * 申请人id
     */
    @TableField(value = "apply_user_id")
    private String applyUserId;

    /**
     * 申请人
     */
    @TableField(value = "apply_user")
    private String applyUser;

    /**
     * 申请时间
     */
    @TableField(value = "apply_time")
    private Date applyTime;

    /**
     * 审核状态（none,未接入审核流，working审批中，finished）

     */
    @TableField(value = "examine_state")
    private String examineState;

    /**
     * 备注
     */
    private String note;

    /**
     * 创建时间
     */
    @TableField(value = "create_time",fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time",fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 创建人员
     */
    @TableField(value = "create_user")
    private String createUser;

    /**
     * 更新人员
     */
    @TableField(value = "update_user")
    private String updateUser;


}