package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.junmp.jyzb.entity.Cabinet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value="com-junmp-jyzb-domain-Policeman")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_policeman")
public class Policeman implements Serializable {

    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    @TableField(value = "name")
    private String name;

    @TableField(value = "cabinet_box_id",updateStrategy  = FieldStrategy.IGNORED)
    private String cabinetBoxId;

    @TableField(value = "org_id_int")
    private Long orgId;

    @TableField(value = "department_id")
    private Long departmentId;

    @TableField(value = "police_code")
    private String policeCode;

    @TableField(value = "sex")
    private String sex;

    @TableField(value = "face_info",updateStrategy  = FieldStrategy.IGNORED)
    private String faceInfo;

    @TableField(value = "isCreatedAccount")
    private Integer isCreatedAccount;

    @TableField(value = "door_code")
    private String doorCode;

    @TableField(value = "password",updateStrategy  = FieldStrategy.IGNORED)
    private String password;

    @TableField(value = "photo")
    private String photo;

    @TableField(value = "phone",updateStrategy = FieldStrategy.IGNORED)
    private String phone;

    @TableField(fill = FieldFill.INSERT, value = "create_time")
    private Date createTime;

    @TableField(fill = FieldFill.UPDATE, value = "update_time")
    private Date updateTime;

    @TableField(value = "id_card")
    private String idCard;

    @TableField(value = "update_user")
    private String updateUser;

    @TableField(value = "state")
    private Integer state;

    @TableField(value = "user_id",updateStrategy  = FieldStrategy.IGNORED)
    private Long UserId;

    @TableField(value = "file_content")
    private String fileContent;

    private static final long serialVersionUID = 1L;
}