package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("bussiness_order_main")
public class OrderMain implements Serializable {

    private String id;

    @TableField("order_type")
    private String orderType;

    @TableField("process_id")
    private String processId;

    @TableField("bussiness_type")
    private String bussinessType;

    @TableField("order_code")
    private String orderCode;

    @TableField("start_org_id")
    private Long startOrgId;

    @TableField("start_org_name")
    private String startOrgName;

    @TableField("end_org_id")
    private Long endOrgId;

    @TableField("end_org_name")
    private String endOrgName;

    @TableField("start_org_user_id")
    private String startOrgUserId;

    @TableField("start_org_user_name")
    private String startOrgUserName;

    @TableField("end_org_user_id")
    private String endOrgUserId;

    @TableField("end_org_user_name")
    private String endOrgUserName;

    @TableField("examine_state")
    private String examineState;

    @TableField("form_item")
    private String formItem;


    @TableField("price")
    private BigDecimal price;

    @TableField("inventory_quantity")
    private Integer inventoryQuantity;

    @TableField("actual_quantity")
    private Integer actualQuantity;

    @TableField("manual_state")
    private Integer manualState;

    @TableField("order_state")
    private String orderState;

    @TableField("attachment_location")
    private String attachmentLocation;

    @TableField("inv_list")
    private String invList;

    @TableField("return_date")
    private Date returnDate;

    @TableField("use_date")
    private Date useDate;


    @TableField("note")
    private String note;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.UPDATE)
    private Date updateTime;

    @TableField("create_user")
    private String createUser;

    @TableField("update_user")
    private String updateUser;

    /**
     * 生产厂商id
     */
    @TableField("manufacturer_id")
    private String manufacturerId;

    /**
     * 调拨类型（0支拨，1价拨）
     */
    @TableField("transfer_type")
    private Integer transferType;
    /**
     * 归还人，归还入库特有
     */
    @TableField("return_user_id")
    private String returnUserId;

    private static final long serialVersionUID = 1L;
}