package com.junmp.jyzb.controller;


import com.junmp.jyzb.api.bean.req.FormEqsReq;
import com.junmp.jyzb.service.PoliceEquipmentService;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
@Slf4j
@RequestMapping("/ToOut")
@Api(tags = "出库模块")
public class ToOutController {
    @Resource
    private PoliceEquipmentService policeEquipmentService;

    //警员借用装备后在在数据库中增加相关借用装备数据
    @PostMapping("/AddBorrowEqs")
    @ApiOperation("增加警员借用装备数据信息")
    public ApiRes<Boolean> AddBorrowEqs(FormEqsReq req){
        return ApiRes.success(policeEquipmentService.AddPoliceEqs(req));
    }
    //警员领用装备后在数据库中增加相关领用装备数据
    @PostMapping("/AddTakeEqs")
    @ApiOperation("增加警员领用装备数据信息")
    public ApiRes<Boolean> AddTakeEqs(FormEqsReq req){
        return ApiRes.success(policeEquipmentService.AddPoliceEqs(req));
    }

}
