package com.junmp.jyzb.controller;

import cn.hutool.db.Page;
import com.junmp.jyzb.api.bean.dto.EquipmentSizeDto;
import com.junmp.jyzb.api.bean.query.QueryEquipmentSizeReq;
import com.junmp.jyzb.api.bean.req.UpdateEquipmentSizeReq;
import com.junmp.jyzb.entity.EquipmentSize;
import com.junmp.jyzb.service.EquipmentSizeService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/Size")
@Api(tags = "号型基础信息模块")
public class EquipmentSizeController {
    @Resource
    public EquipmentSizeService equipmentSizeService;

    @PostMapping("/AddSize")
    @ApiOperation("添加号型信息")
    public ApiRes<String> addSize(@RequestBody @Validated(ValidationApi.add.class) UpdateEquipmentSizeReq req) {
        return ApiRes.success(equipmentSizeService.addSize(req));
    }

    @PostMapping("/DeleteSize")
    @ApiOperation("删除号型信息")
    public ApiRes<Boolean> deleteSize(@RequestBody @Validated(ValidationApi.delete.class) UpdateEquipmentSizeReq req) {
//        ResponseResult returnMsg = equipmentSizeService.deleteSize(msg);
//        return returnMsg;
        return ApiRes.success(equipmentSizeService.deleteSize(req));
    }

    @PostMapping("/GetOneSize")
    @ApiOperation("查询单个号型信息")
    public ApiRes<EquipmentSize> getOneSize(@RequestBody QueryEquipmentSizeReq req) {
        //ResponseResult returnMsg =
        return ApiRes.success(equipmentSizeService.getOneSize(req));
    }

    @PostMapping("/ShowSize")
    @ApiOperation("根据装备类型查询号型")
    public ApiRes<List<EquipmentSizeDto>> getAllSize(@RequestBody QueryEquipmentSizeReq req){
        return ApiRes.success(equipmentSizeService.getAllSize(req));
    }
    @PostMapping("/GetSizePage")
    @ApiOperation("分页查询号型信息")
    public ApiRes<PageResult<EquipmentSizeDto>> getSizePage(@RequestBody QueryEquipmentSizeReq req){
        return ApiRes.success(equipmentSizeService.getSizePages(req));
    }

    @PostMapping("/UpdateSize")
    @ApiOperation("修改号型信息")
    public ApiRes<Boolean> updateSize(@RequestBody @Validated(ValidationApi.edit.class) UpdateEquipmentSizeReq req) {
        return ApiRes.success(equipmentSizeService.updateSize(req));
    }

    @PostMapping("/ChangeSizeState")
    @ApiOperation("禁用/启用装备号型")
    public ApiRes<Boolean> changeSizeState(@RequestBody @Validated(ValidationApi.updateStatus.class) UpdateEquipmentSizeReq req) {
        return ApiRes.success(equipmentSizeService.changeSizeState(req));
    }


}
