package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum OrderExceptionEnum implements IExceptionEnum {
    ORDER_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE,"单据不存在"),
    ERROR_COMMOAND(CommonConstant.DEFAULT_USER_ERROR_CODE,"操作有误，无法既删除又修改"),
    ORDER_CAN_NOT_UPDATE(CommonConstant.DEFAULT_USER_ERROR_CODE,"进行中的单据或已完成的单据无法修改"),
    ORDERDETAIL_ISNOT_NULL(CommonConstant.DEFAULT_USER_ERROR_CODE,"记账子单据不能为空"),
    ORDERDETAIL_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE,"子单据不存在"),
    ORDERDETAIL_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE,"子单据不一致，操作失败"),
    ;

    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    OrderExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
