package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
public class UpdatePolicemanReq extends BaseRequest {

    @NotBlank(message = "警员主键不能为空", groups = {edit.class, delete.class, detail.class,updateStatus.class})
    private String id;

    @NotBlank(message = "警员名字不能为空", groups = {add.class,edit.class})
    private String name;

    private String cabinetBoxId;

    @NotNull(message = "组织机构id不能为空", groups = {add.class,edit.class})
    private Long orgId;

    private Long departmentId;

    @NotBlank(message = "警员编号不能为空", groups = {add.class,edit.class})
    private String policeCode;

    @NotBlank(message = "性别不能为空", groups = {add.class,edit.class})
    private String sex;

    @NotBlank(message = "人脸信息不能为空", groups = {detail.class})
    private String faceInfo;

    //是否同步生成账号  1已生成，0未生成
    private Integer isCreatedAccount;

    private String doorCode;

    private String password;

    private String photo;

    @NotBlank(message = "电话不能为空", groups = {add.class,edit.class})
    private String phone;

    private Date createTime;

    private Date updateTime;

    @NotBlank(message = "身份证号不能为空", groups = {add.class,edit.class})
    private String idCard;

    private String updateUser;

    @NotNull(message = "状态不能为空", groups = {updateStatus.class})
    private Integer state;

    private String fileContent;

    private static final long serialVersionUID = 1L;
}