package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class UpdateOrderReq extends BaseRequest implements Serializable {
    @NotBlank(message = "id不能为空",groups = {edit.class})
    private String id;

    private String examineState;

    /**
     * 单据类型：入库单/出库单
     */
    @NotNull(message = "状态不能为空", groups = {updateStatus.class})
    private String orderType;
    /**
     * 工作流ID
     */
    private String  processId;
    /**
     * 单据业务类型
     */
    private String  bussinessType;
    /**
     * 订单号
     */
    private String  orderCode;
    /**
     * 发物单位
     */
    private String  startOrgId;
    /**
     * 发物单位名称
     */
    private String  startOrgName;
    /**
     * 收物单位
     */
    private String  endOrgId;
    /**
     * 收物单位名称
     */
    private String  endOrgName;
    /**
     * 发物单位负责人id
     */
    private String  startOrgUserId;
    /**
     * 发物单位负责人姓名
     */
    private String  startOrgUserName;
    /**
     * 收物单位负责人id
     */
    private String  endOrgUserId;
    /**
     * 收物单位负责人姓名
     */
    private String  endOrgUserName;
    /**
     * 总价格
     */
    private String  price;
    /**
     * 应入库数量
     */
    private String  inventoryQuantity;
    /**
     * 附件地址
     */
    private String  attachmentLocation;
    /**
     * 单据包含的物资集合
     */
    private String  invList;
    /**
     * 表单内容
     */
    private String  formItem;

//    /**
//     * 表单内容
//     */
//    private String  detailList;
    /**
     * 删除装备列表
     */
    private List<Long>  deleteList;
    /**
     * 明细列表
     */
    private List<DetailListReq>  detailList;

    /**
     * 生产厂商id
     */
    private String manufacturerId;

    /**
     * 调拨类型（0支拨，1价拨），调拨出入库才有
     */
    private Integer transferType;

    /**
     * 归还人，归还入库特有
     */
    private String returnUserId;

}

