package com.junmp.jyzb.api.bean.req;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class BaseOrderReq extends BaseRequest {
    /**
     * 单子id
     */
    @NotBlank(message = "id不能为空",groups = {edit.class})
    private String id;

    /**
     * 工作流id
     */
    private String processId;

    /**
     * 单据类型（个人装备的移交handOver，报废broken，维修fix）
     */
    private String bussinessType;

    /**
     * 申请时间
     */
    private Date applyTime;

    /**
     * 申请人
     */
    private String applicantId;

    /**
     * 接收人
     */
    private String recipientId;

    /**
     * 申请理由
     */
    private String applyReason;

    /**
     * 仓库id
     */
    private String locationId;

    /**
     * 总数量
     */
    private Integer totalNum;

    /**
     * 总价格
     */
    private BigDecimal price;

    /**
     * 审核状态:none,未接入审核流，working审批中，finished
     */
    private String examineState;

    /**
     * 申请人组织机构id
     */
    private Long orgId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 创建人员
     */
    private String createUser;

    /**
     * 更新人员
     */
    private String updateUser;

    /**
     * 子单据
     */
    private List<BaseOrderItemReq> orderItemList;

    /**
     * 删除装备列表
     */
    private List<Long>  deleteList;
}
