package com.junmp.jyzb.api.bean.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
public class OrderDto implements Serializable {
    private String id;
    /**
     * 单据类型：入库单/出库单
     */
    private String orderType;
    /**
     * 工作流ID
     */
    private String  processId;
    /**
     * 单据业务类型
     */
    private String  bussinessType;
    /**
     * 订单号
     */
    private String  orderCode;
    /**
     * 发物单位
     */
    private String  startOrgId;
    /**
     * 发物单位名称
     */
    private String  startOrgName;
    /**
     * 收物单位
     */
    private String  endOrgId;
    /**
     * 收物单位名称
     */
    private String  endOrgName;
    /**
     * 发物单位负责人id
     */
    private String  startOrgUserId;
    /**
     * 发物单位负责人姓名
     */
    private String  startOrgUserName;
    /**
     * 收物单位负责人id
     */
    private String  endOrgUserId;
    /**
     * 收物单位负责人姓名
     */
    private String  endOrgUserName;
    /**
     * 总价格
     */
    private BigDecimal price;
    /**
     * 应入库数量
     */
    private String  inventoryQuantity;
    /**
     * 单据包含的物资集合
     */
    private String  invList;

    /**
     * 生产厂商id
     */
    private String manufacturerId;
    /**
     * 明细列表
     */
    private List<OrderDetailDto>  detailList;

}
