package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.EquipmentTreeDto;
import com.junmp.jyzb.api.bean.dto.OrgTreeDto;
import com.junmp.jyzb.api.bean.query.QueryEquipmentTypeReq;
import com.junmp.jyzb.api.bean.query.QueryOrgReq;
import com.junmp.jyzb.api.bean.req.OrgUpdateReq;
import com.junmp.jyzb.api.bean.query.ProductTagReq;
import com.junmp.jyzb.entity.EquipmentType;
import com.junmp.jyzb.entity.PubOrg;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.RedisUtils;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.jyzb.utils.ReturnMsg;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.PubOrgMapper;
import com.junmp.jyzb.service.PubOrgService;

import java.util.*;
import java.util.stream.Collectors;

import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
public class PubOrgServiceImpl extends ServiceImpl<PubOrgMapper, PubOrg>  implements PubOrgService{

    @Resource
    private PubOrgMapper pubOrgMapper;

    @Autowired
    private RedisUtils redisUtils;

    public List<Map<String,Object>> showPubOrgList(Map<String, Object> orgId) {
        // 构建 Redis 缓存键
        String redisKey = "showPubOrgList";

        Long orgInfo = Long.valueOf(orgId.get("orgId").toString());//获取输入的组织机构id信息

        // 从 Redis 中获取数据
        List<PubOrg> cachedData = redisUtils.findCachedData(redisKey);
        List<PubOrg> menuList = new ArrayList<>();
        if (cachedData != null) {
            menuList = cachedData;
        } else {
            // 从数据库获取数据并将结果存入 Redis 缓存
            menuList = pubOrgMapper.selectAllOrg();
            redisUtils.set(redisKey, menuList);
        }

        List<Map<String, Object>> topList = new ArrayList<>();
        List<Map<String, Object>> resultList = new ArrayList<>();
        Map<Long, List<Map<String, Object>>> childrenMap = new HashMap<>();

        // 构建子菜单映射表
        for (PubOrg menu : menuList) {
            Map<String, Object> map = new HashMap<>();
            map.put("id", menu.getOrgId());
            map.put("parentId", menu.getOrgParentId());
            map.put("findCode", menu.getFindCode());
            map.put("orgName", menu.getDName());
            map.put("statusFlag",menu.getStatusFlag());

            if (!childrenMap.containsKey(menu.getOrgParentId())) {
                childrenMap.put(menu.getOrgParentId(), new ArrayList<>());
            }
            childrenMap.get(menu.getOrgParentId()).add(map);

            //构建最顶级的菜单
            if (menu.getOrgId().equals(orgInfo)){
                Map<String, Object> topMap = new HashMap<>();
                topMap.put("id", menu.getOrgId());
                topMap.put("parentId", menu.getOrgParentId());
                topMap.put("findCode", menu.getFindCode());
                topMap.put("orgName", menu.getDName());
                topMap.put("statusFlag",menu.getStatusFlag());
                topList.add(topMap);
            }
        }

        // 获取顶级菜单
        List<Map<String, Object>> topMenus = childrenMap.get(orgInfo);

        // 迭代构建菜单树
        if (topMenus != null) {

            for (Map<String, Object> topMenu : topMenus) {
                Stack<Map<String, Object>> stack = new Stack<>();
                stack.push(topMenu);

                // 使用栈进行深度优先遍历
                while (!stack.isEmpty()) {
                    Map<String, Object> currentMenu = stack.pop();
                    Long currentMenuId = (Long) currentMenu.get("id");

                    if (childrenMap.containsKey(currentMenuId)) {
                        List<Map<String, Object>> children = childrenMap.get(currentMenuId);
                        currentMenu.put("children", children);

                        for (int i = children.size() - 1; i >= 0; i--) {
                            stack.push(children.get(i));
                        }
                    }
                }
                resultList.add(topMenu);
            }
        }

        if (orgInfo == -1) {
            //modifyList(resultList);

            // 如果输入的是浙江省公安厅,就将下级的组织机构进行排序
            for (Map<String, Object> orgMsg : resultList) {
                List<Map<String, Object>> children = (List<Map<String, Object>>) orgMsg.get("children");
                // 根据findCode从小到大排序
                children.sort(Comparator.comparing(m -> m.get("findCode").toString()));
            }

            return resultList;
        }

        //将resultList的内容放在顶级菜单的resultList中
        for (Map<String,Object> oneMap:topList){
            oneMap.put("children",resultList);
        }

        // 遍历并添加父类的相关信息到children的第一个位置
        modifyList(topList);

        if (orgInfo.equals(1369509498032808905L)) {
            // 如果输入的是浙江省公安厅,就将下级的组织机构进行排序
            for (Map<String, Object> orgMsg : topList) {
                List<Map<String, Object>> children = (List<Map<String, Object>>) orgMsg.get("children");
                // 根据findCode从小到大排序
                children.sort(Comparator.comparing(m -> m.get("findCode").toString()));
            }
            return topList;
        }

        // 返回结果
        return topList;
    }

    //将父类信息放在children的第一个位置
    private static void modifyList(List<Map<String, Object>> list) {
        for (Map<String, Object> item : list) {
            // 获取当前节点的ID
            Map<String,Object> setMsg = new HashMap<>();
            setMsg.put("id", item.get("id").toString() + "-0"); //在最后面加个 -0 来表示列表的唯一id
            setMsg.put("parentId", item.get("parentId").toString());
            setMsg.put("findCode", item.get("findCode").toString());
            setMsg.put("orgName", item.get("orgName").toString());
            setMsg.put("statusFlag",item.get("statusFlag"));

            // 将当前节点的ID添加到子节点的第一个位置
            @SuppressWarnings("unchecked")
            List<Map<String, Object>> children = (List<Map<String, Object>>) item.get("children");
            if (children != null && children.size() > 0) {
                //将父类的相关信息放在children的第一个位置
                children.add(0,setMsg);

                // 递归处理子节点
                modifyList(children);
            }
        }
    }

    //删除前缀
    public static Map<String,Object> removeFront(Map<String,Object> map, String name1,List<String> name2,List<String> name3) {
        String orgName = map.get("orgName").toString();

        orgName = removeStringAndBefore(orgName,name1);

        for (String name:name2){
            orgName = removePrefix(orgName,name);
            for (String staticName:name3){
                orgName = removePrefix(orgName,staticName);
            }
        }
        map.put("orgName",orgName);
        return map;
    }

    //找到字符串出现的位置，删掉字符串及前缀
    public static String removeStringAndBefore(String name, String deleteMsg) {
        int index = name.indexOf(deleteMsg);
        if (index != -1) {
            return name.substring(index + deleteMsg.length());
        }
        return name;
    }

    //例：传入abc,a ==>bc 删掉开头的字符串，不是就不删除
    public static String removePrefix(String name, String deleteName) {
        if (name.startsWith(deleteName)) {
            return name.substring(deleteName.length());
        } else {
            return name;
        }
    }



    @Override
    public List<String> getLowerOrg(String orgId) {
        //构建 Redis 缓存�
        String redisKey = "getLowerOrg";

        // �Redis 中获取数�
        List<PubOrg> cachedData = redisUtils.findCachedData(redisKey);
        List<PubOrg> menuList = new ArrayList<>();
        if (cachedData!=null){
            menuList = cachedData;
        }else {
            menuList = pubOrgMapper.selectAllOrg();
            redisUtils.set(redisKey, menuList);
        }

        List<String> resultList = new ArrayList<>();  // 存储最终的菜单树结果
        Map<String, List<String>> childrenMap = new HashMap<>();  // 存储每个菜单项的子菜单映射

        resultList.add(orgId); //将自己加入到返回的List中

        // 构建子菜单映射表
        for (PubOrg menu : menuList) {
            String org = menu.getOrgId().toString();

            if (!childrenMap.containsKey(menu.getOrgParentId().toString())) {  // 如果父菜单还不存在于映射表中
                childrenMap.put(menu.getOrgParentId().toString(), new ArrayList<>());  // 创建一个新的子菜单列表
            }
            childrenMap.get(menu.getOrgParentId().toString()).add(org);  // 将当前菜单项放入对应的子菜单列表中
        }

        Long orgInfo = Long.valueOf(orgId);//获取输入的组织机构id信息
        //Long orgInfo = new BigInteger(orgId);  // 获取顶级菜单的标识符

        // 获取顶级菜单
        List<String> topMenus = childrenMap.get(orgId);

        // 迭代构建菜单树
        if (topMenus != null) {

            for (String topMenu : topMenus) {
                Stack<String> stack = new Stack<>();  // 使用栈结构辅助构建菜单树
                stack.push(topMenu);  // 将当前顶级菜单项放入栈中

                while (!stack.isEmpty()) {
                    String currentMenu = stack.pop(); // 取出队首的当前菜单项
                    //Long currentMenuId = currentMenu;  // 获取当前菜单项的标识符

                    if (childrenMap.containsKey(currentMenu)) {  // 如果当前菜单项有子菜单
                        List<String> children = childrenMap.get(currentMenu);  // 获取子菜单列表

                        for (int i = children.size() - 1; i >= 0; i--) {
                            stack.push(children.get(i));
                        }
                    }

                    resultList.add(currentMenu);  // 将已经处理完的当前菜单项添加到结果列表中
                }
            }

        }

        return resultList;
    }

    @Override
    public ResponseResult setOrgParentIds() {
        //清空parent_ids字段
        pubOrgMapper.wipeParentIdsData();
        //更新parent_ids字段
        pubOrgMapper.setOrgParentIds();
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    @Override
    public ResponseResult setShortName(Map<String, Object> orgId) {

        List<PubOrg> menuList = pubOrgMapper.selectAllOrg();
        List<Map<String, Object>> resultList = new ArrayList<>();
        for (PubOrg menu : menuList) {
            if (menu.getOrgParentId().toString().equals((orgId.get("orgId")))) {
                Map<String, Object> map = new HashMap<>();
                map.put("id", menu.getOrgId());
                map.put("parentId", menu.getOrgParentId());
                //去掉前缀
                String name1 = menu.getOrgName(); //name1 ,获得“浙江省公安厅”
                //List<String> name2 = null;
                List<String> name2 = new ArrayList<>();
                //name3为固定字段
                List<String> name3 = new ArrayList<>();
                name3.add("公安局");
                name3.add("公安");
                name3.add("分局");

                if (menu.getOrgName().length()>3 && name2.size() <2 && (menu.getOrgName().charAt(2)=='省' ||menu.getOrgName().charAt(2)=='市')){
                    String nameHistory = menu.getOrgName().substring(0,3); //name2 ,获得“浙江省”
                    name2.add(nameHistory);
                    name2.add(" ");
                    name2.add(" ");

                }

                if (menu.getOrgName().length()>3 && (menu.getOrgName().charAt(2)=='区')){
                    name2.remove(2);
                    String nameHistory = menu.getOrgName().substring(0,3);
                    name2.add(2,nameHistory);
                }

                map.put("orgName", name1);
                List<Map<String, Object>> children = getChildMenus(menu.getOrgId(),menuList,name1,name2,name3);//name为要删掉的前缀
                if (!children.isEmpty()) {
                    map.put("children", children);
                    for (Map<String,Object> msg:children){
                        Long id = (Long) msg.get("id");
                        String orgName = msg.get("orgName").toString();
                        pubOrgMapper.setMsg(id,orgName);
                    }
                }
                //map.put("children", getChildMenus(menu.getOrgId(),menuList,name1,name2,name3));
                resultList.add(map);


            }
        }

        return new ResponseResult(HttpStatus.SUCCESS,"操作成功",resultList);
    }

    private List<Map<String, Object>> getChildMenus(Long parentId, List<PubOrg> menuList,String deleteName1,List<String> deleteName2,List<String> deleteName3) {
        List<Map<String, Object>> childList = new ArrayList<>();
        for (PubOrg menu : menuList) {
            //if (menu.getParentId() != null && menu.getParentId().equals(parentId)) {
            if (menu.getOrgParentId().toString().equals(parentId.toString())) {
                Map<String, Object> map = new HashMap<>();
                map.put("id", menu.getOrgId());
                map.put("parentId", menu.getOrgParentId());
                //去掉前缀
                String name1 = menu.getOrgName();
                List<String> name2 = new ArrayList<>();
                name2 = deleteName2;
                String result = removePrefix(name1, deleteName1);
                //遍历name2删掉前缀
                for (String nameMsg:name2){
                    result = removePrefix(result, nameMsg);
                    for (String name3:deleteName3){
                        result = removePrefix(result, name3);
                    }
                }
                map.put("orgName", result);
                if (result.length()>3 && (result.charAt(2)=='省' ||result.charAt(2)=='市')){
                    name2.remove(1);
                    String nameHistory = result.substring(0,3); //获得“绍兴市”
                    name2.add(1,nameHistory);
                }

                if (result.length()>3 && (result.charAt(2)=='区' ||result.charAt(2)=='县')){
                    name2.remove(2);
                    String nameHistory = result.substring(0,3);
                    name2.add(2,nameHistory);
                }

                List<Map<String, Object>> children = getChildMenus(menu.getOrgId(), menuList,name1,name2,deleteName3);
                if (!children.isEmpty()) {
                    map.put("children", children);
                }
                childList.add(map);
            }
        }
        return childList;
    }

//    @Override
//    public ResponseResult getOrgDetail(QueryOrgReq msg) {
//        try {
//            checkNotBlank(msg.get("orgId"), "orgId不能为空");
//        } catch (IllegalArgumentException e) {
//            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
//        }
//
//        String orgId = msg.get("orgId").toString();
//
//        Map<String,Object> resultList = pubOrgMapper.getOrgDetail(orgId);
//        return new ResponseResult(HttpStatus.SUCCESS, "操作成功", resultList);
//    }

    public List<OrgTreeDto> getOrgList(QueryOrgReq req) {
        String selfCode = "1369509498032808905";
        List<OrgTreeDto> OrgDTOList=new ArrayList<>();
        LambdaQueryWrapper<PubOrg> wrapper = new LambdaQueryWrapper<>();
        String setNewCode = "";
        List<PubOrg> orgList = new ArrayList<>();
        if (ObjectUtil.isNotEmpty(req.getOrgCode())) {
            setNewCode = req.getOrgCode().replaceAll("0+$", "");
        }
        wrapper.eq( PubOrg::getStatusFlag, 1);
        wrapper.likeRight(ObjectUtil.isNotEmpty(req.getOrgCode()), PubOrg::getOrgCode, setNewCode);
        orgList = this.list(wrapper);

        // 创建一个 Map 来存储机构 ID 和对应的 DTO 对象
        Map<String, OrgTreeDto> orgDtoMap = new HashMap<>();
        // 创建一个 Map 来存储父类的 parentid 和对应的父类节点
        Map<String, OrgTreeDto> parentDtoMap = new HashMap<>();
        if (ObjectUtil.isNotEmpty(req.getOrgCode()) && !req.getOrgCode().equals("330000000000")) {
            LambdaQueryWrapper<PubOrg> wrapper2 = new LambdaQueryWrapper<>();
            if (ObjectUtil.isNotEmpty(req.getOrgCode())) {
                selfCode = req.getOrgCode();
            }
            wrapper2.eq(ObjectUtil.isNotEmpty(req.getOrgCode()), PubOrg::getOrgCode, selfCode);
            PubOrg orgA= this.getOne(wrapper2);
            String id = this.getOne(wrapper2).getOrgId().toString();
            selfCode = id;
            PubOrg org = this.getById(Long.parseLong(id));
            OrgTreeDto orgDTO = new OrgTreeDto();
            orgDTO.setName(org.getDName());
            orgDTO.setCode(org.getOrgCode());
            orgDTO.setType(org.getOrgType());
            orgDtoMap.put(org.getOrgId().toString(), orgDTO);
        }

        // 第一轮遍历：创建 OrgTreeDto 对象并将其加入到 Map 中
        for (PubOrg org : orgList) {
            OrgTreeDto orgDTO = new OrgTreeDto();
            orgDTO.setName(org.getDName());
            orgDTO.setCode(org.getOrgCode());
            orgDTO.setType(org.getOrgType());
            orgDtoMap.put(org.getOrgId().toString(), orgDTO);

            // 如果 parentid 是传进来的值，则将其作为顶级节点添加到 OrgDTOList 中
            if (org.getOrgId().toString().equals(selfCode)) {
                OrgDTOList.add(orgDTO);
            }
        }

        // 第二轮遍历：将子节点连接到父节点或添加为顶级节点
        boolean isStartAddingChildren = false;
        for (PubOrg org : orgList) {
            String parentId = org.getOrgParentId().toString();
            OrgTreeDto orgDTO = orgDtoMap.get(org.getOrgId().toString());

            // 如果找到传入的ID对应的节点，则开始添加子节点
            if (org.getOrgId().toString().equals(selfCode)) {
                isStartAddingChildren = true;
            }

            // 如果 isStartAddingChildren 为 true，并且 parentDtoMap 中有对应的父类节点，则将节点连接到父节点
            if (isStartAddingChildren && parentDtoMap.containsKey(parentId)) {
                OrgTreeDto parentDto = parentDtoMap.get(parentId);
                parentDto.addChild(orgDTO);
            }

            // 将当前节点添加到 parentDtoMap 中，以便后续节点连接
            parentDtoMap.put(org.getOrgId().toString(), orgDTO);
        }

        return OrgDTOList;
    }
    @Override
    public ResponseResult changeOrgState(OrgUpdateReq req) {
        LambdaQueryWrapper<PubOrg> wrapper = new LambdaQueryWrapper<>();


        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS);
    }

    private LambdaQueryWrapper<PubOrg> createWrapper(ProductTagReq req) {
        LambdaQueryWrapper<PubOrg> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }

        return wrapper;
    }

}










