package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.CabinetDto;
import com.junmp.jyzb.api.bean.dto.CabinetBoxDto;
import com.junmp.jyzb.api.bean.dto.CabinetDto;
import com.junmp.jyzb.api.bean.query.CabinetBoxReq;
import com.junmp.jyzb.api.bean.query.CabinetReq;
import com.junmp.jyzb.api.bean.req.UpdateCabinetBoxReq;
import com.junmp.jyzb.api.bean.req.UpdateCabinetReq;
import com.junmp.jyzb.entity.Cabinet;
import com.junmp.jyzb.entity.CabinetBox;
import com.junmp.jyzb.entity.Policeman;
import com.junmp.jyzb.entity.PubOrg;
import com.junmp.jyzb.exception.enums.CabinetExceptionEnum;
import com.junmp.jyzb.exception.enums.PolicemanExceptionEnum;
import com.junmp.jyzb.exception.enums.PubOrgExceptionEnum;
import com.junmp.jyzb.mapper.*;
import com.junmp.jyzb.service.CabinetBoxService;
import com.junmp.jyzb.service.CabinetService;
import com.junmp.jyzb.service.PolicemanService;
import com.junmp.jyzb.service.PubOrgService;
import com.junmp.jyzb.utils.*;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

import java.util.*;

import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
public class CabinetServiceImpl extends ServiceImpl<CabinetMapper, Cabinet> implements CabinetService {

    @Resource
    private RedisUtils redisUtils;

    @Resource
    private CabinetMapper cabinetMapper;

    @Resource
    private CabinetBoxMapper cabinetBoxMapper;

    @Resource
    private PolicemanMapper policemanMapper;

    @Resource
    private PubOrgMapper pubOrgMapper;

    @Resource
    private PubOrgService pubOrgService;
    @Resource
    private CabinetBoxService cabinetBoxService;

    @Resource
    private PolicemanService policemanService;

    private static final String REDIS_CABINET = "Cabinet_";



    @Override
    public Map<String, Object> getOneCabinet(String id) {

        return cabinetMapper.getOneCabinet(id);
    }



    //查询某组织机构的所有子机构
    public List<String> getSubIds(String id) {
        List<String> subIds = new ArrayList<>();
        subIds.add(id);//先往List中放入父级id
        List<String> subMenus = policemanMapper.getChildren(id);//查询该id的子类id
        if (subMenus != null) {
            for (String subMenu : subMenus) {
                subIds.addAll(getSubIds(subMenu));
            }
        }
        return subIds;
    }



    @Override
    public List<String> getAllCabinetBoxId(String id) {
        List<String> msg = cabinetMapper.getAllCabinetBoxId(id);
        return msg;
    }


    private List<String> getAllOrgId(CabinetReq req, String includeLowerLevel) {
        List<String> allOrg = new ArrayList<>();
        if (includeLowerLevel.equals("false")) {
            allOrg.add(req.getOrgId());
        } else if (includeLowerLevel.equals("true")) {
            //查询某组织机构的本级及下级
            allOrg = pubOrgService.getLowerOrg(req.getOrgId());
        }
        return allOrg;
    }

    private List<Cabinet> getAllCabinetByOrg( List<String> allOrgId) {
        List<Cabinet> allCabinet = new ArrayList<>();
        allCabinet = cabinetMapper.getAllCabinetByOrgList(allOrgId);
        return allCabinet;
    }

    @Override
    public List<String> getAllCabinetId(Map<String, Object> msg) {
        //如果组织机构是最高级的，获取所有id
        if (msg.get("orgId").toString().equals("1369509498032808905")) {
            //构建 Redis 缓存键
            String redisKey = "getAllCabinetId_" + msg.get("IncludeLowerLevel") + '_' + msg.get("orgId");
            // 从 Redis 中获取数据
            List<String> cachedData = redisUtils.findCachedData(redisKey);
            if (cachedData != null) {
                return cachedData;
            }
            List<String> allCabinetId = cabinetMapper.getAllCabinetIdByHighest();
            //将查询结果存入 Redis 中
            redisUtils.set(redisKey, allCabinetId);
            return allCabinetId;
        }

        //构建 Redis 缓存键
        String redisKey = "getAllCabinetId_" + msg.get("IncludeLowerLevel") + '_' + msg.get("orgId");
        // 从 Redis 中获取数据
        List<String> cachedData = redisUtils.findCachedData(redisKey);
        if (cachedData != null) {
            return cachedData;
        }
        List<String> cabinetId = new ArrayList<>();
        if (msg.get("IncludeLowerLevel").equals("false")) {
            cabinetId = cabinetMapper.getAllCabinetId(msg.get("orgId").toString());
        } else {
            List<String> orgIds = getSubIds(msg.get("orgId").toString()); //调用本级及下级的所有组织机构的id
            for (String orgId : orgIds) {
                List<String> allPoliceId = cabinetMapper.getAllCabinetId(orgId);
                cabinetId.addAll(allPoliceId);
            }
        }
        //将查询结果存入 Redis 中
        redisUtils.set(redisKey, cabinetId);
        return cabinetId;
    }


    public ResponseResult setCabinetInventory(Map<String, Object> msg) {
        String id;
        if (msg.containsKey("locationId") && msg.get("locationId") != "") {
            id = msg.get("locationId").toString();
        } else {
            id = null;
        }
        //统计仓库 装备总数
        cabinetMapper.setCabinetSumInventory(id);
        //统计仓库 装备在库总数
        cabinetMapper.setCabinetInSumInventory(id);
        //统计仓库 装备出库总数
        cabinetMapper.setCabinetOutSumInventory(id);
        //统计仓库 装备出库总数
        cabinetMapper.setCabinetPriceInventory(id);
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }


    /**
     * 添加单警柜
     *
     * @param req
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public String addCabinetInfo(UpdateCabinetReq req) {
        Cabinet cabinet = new Cabinet();
        //查询传入的组织机构id是否存在
        PubOrg puborg = pubOrgService.getOne(new LambdaQueryWrapper<PubOrg>()
                .eq(ObjectUtil.isNotEmpty(req.getOrgId()),PubOrg::getOrgId,req.getOrgId()));
        if (ObjectUtil.isEmpty(puborg)) {
            //抛出组织机构不存在异常
            throw new ServiceException(PubOrgExceptionEnum.PUBORG_NOT_EXIST);
        }
        //查询是否有重复的单警柜编号
        List<Cabinet> list = this.list(new LambdaQueryWrapper<Cabinet>()
                .eq(ObjectUtil.isNotEmpty(req.getCabinetNum()),Cabinet::getCabinetNum,req.getCabinetNum()));
        if (list.size()>0) {
            //抛出单警柜重复异常
            throw new ServiceException(CabinetExceptionEnum.CABINETID_IS_EXISTS);
        }
        BeanPlusUtil.copyProperties(req, cabinet);
        cabinet.setCreateTime(DateTimeUtil.getCurrentDateTime());
        cabinet.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        //添加单警柜
        save(cabinet);
        Cabinet one = getOne(new LambdaQueryWrapper<Cabinet>()
                .eq(ObjectUtil.isNotEmpty(ObjectUtil.isNotEmpty(req.getCabinetNum())), Cabinet::getCabinetNum, req.getCabinetNum())
                .eq(ObjectUtil.isNotEmpty(ObjectUtil.isNotEmpty(req.getOrgId())), Cabinet::getOrgId, req.getOrgId())
                .eq(ObjectUtil.isNotEmpty(ObjectUtil.isNotEmpty(req.getName())), Cabinet::getName, req.getName()));
        List<CabinetBox> objects = new ArrayList<>();
        for (int i = 1; i <= req.getNum(); i++) {
            CabinetBox cabinetBox = new CabinetBox();
            cabinetBox.setCabinetId(one.getId());
            cabinetBox.setState(1);
            cabinetBox.setNum(i);
            //添加到列表进行批量增加
            objects.add(cabinetBox);
        }
        cabinetBoxService.saveBatch(objects);
        return cabinet.getId();
    }


    /**
     * 删除单警柜(批量删除)
     *
     * @param req
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean deleteCabinetInfo(UpdateCabinetReq req) {
        //获取传递的id列表
        List<String> cabinetIdList = req.getCabinetList();
        List<Cabinet> cabinetList=new ArrayList<>();
        //遍历单警柜id列表
        for (String id:cabinetIdList) {
            //通过单警柜id查询出他的箱门数
            Cabinet cabinet = this.getOne(new LambdaQueryWrapper<Cabinet>()
                    .eq(ObjectUtil.isNotEmpty(id), Cabinet::getId,id));
            //如果查询不到单警柜抛出异常
            if (ObjectUtil.isEmpty(cabinet)) {
                throw new ServiceException(CabinetExceptionEnum.CABINET_ISNOT_EXISTS);
            }
            //查询出单警柜之后添加到列表中
            cabinetList.add(cabinet);
            //通过单警柜id循环遍历出并删除所有箱门信息
            List<CabinetBox> list = cabinetBoxService.list(new LambdaQueryWrapper<CabinetBox>()
                    .eq(ObjectUtil.isNotEmpty(id), CabinetBox::getCabinetId, id));
            //创建police列表方便批量删除操作
            List<Policeman> policemanList=new ArrayList<>();
            //创建cabinetBox列表方便批量删除操作
            List<CabinetBox> cabinetBoxList=new ArrayList<>();
            for (CabinetBox cabinetBox: list) {
                CabinetBox cabinetBox1 = new CabinetBox();
                BeanPlusUtil.copyProperties(cabinetBox,cabinetBox1);
                cabinetBoxList.add(cabinetBox1);
                //删除箱门信息的同时需要去判断箱门是否绑定警员，如果有，则解除绑定
                Policeman one = policemanService.getOne(new LambdaQueryWrapper<Policeman>()
                        .eq(ObjectUtil.isNotEmpty(cabinetBox.getId()),Policeman::getCabinetBoxId,cabinetBox.getId()));
                if (!ObjectUtil.isNull(one)){
                    one.setCabinetBoxId(null);
                    policemanList.add(one);
                }
            }
            //批量修改绑定箱门的警员信息，将其解绑
            policemanService.updateBatchById(policemanList);
            //批量删除箱门数
            cabinetBoxService.removeBatchByIds(cabinetBoxList);
            //批量删除单警柜id
            removeBatchByIds(cabinetList);
        }
        return true;
    }

    /**
     * 获取单警柜列表
     *通过机构id进行查询
     * @param req 单警柜信息
     * @param req getIncludeLowerLevel true：查询本级及下级  false：查询本级
     * @return
     */
    @Override
    public List<CabinetDto> getAllCabinetList(CabinetReq req) {
        List<Cabinet> cabinets = new ArrayList<>();
        List<CabinetDto> cabinetList=new ArrayList<>();
        List<CabinetBoxDto> cabinetBoxList=new ArrayList<>();
        //如果组织机构时浙江省公安厅
        if (req.getOrgId().equals("1369509498032808905") && req.getIncludeLowerLevel().equals("true")) {
            cabinets = cabinetMapper.getAllCabinet();
            for (Cabinet cabinet:cabinets) {
                CabinetDto cabinetDto = new CabinetDto();
                BeanPlusUtil.copyProperties(cabinet,cabinetDto);
                //添加箱门信息列表
                List<CabinetBox> list = cabinetBoxService.list(new LambdaQueryWrapper<CabinetBox>()
                        .eq(CabinetBox::getCabinetId, cabinet.getId()));
                for (CabinetBox cabinetBox:list) {
                    CabinetBoxDto cabinetBoxDto = new CabinetBoxDto();
                    BeanPlusUtil.copyProperties(cabinetBox,cabinetBoxDto);
                    cabinetBoxList.add(cabinetBoxDto);
                }
                cabinetDto.setCabinetBoxList(cabinetBoxList);
                cabinetList.add(cabinetDto);
            }
            return cabinetList;
        }
        //分两种情况，如果说是本级及下级（全部）所有的单警柜信息，则incluLowerLevel为true，如果是查询本级的单警柜信息则为false
        if (req.getIncludeLowerLevel().equals("true") || req.getIncludeLowerLevel().equals("false")) {
            List<String> allOrgId = getAllOrgId(req, req.getIncludeLowerLevel());
            if (allOrgId.size()==0) {
                //抛出组织机构不存在异常
                throw new ServiceException(PubOrgExceptionEnum.PUBORG_NOT_EXIST);
            }
            cabinets = getAllCabinetByOrg(allOrgId);
            for (Cabinet cabinet:cabinets) {
                CabinetDto cabinetDto = new CabinetDto();
                BeanPlusUtil.copyProperties(cabinet,cabinetDto);
                //添加箱门信息列表
                List<CabinetBox> list = cabinetBoxService.list(new LambdaQueryWrapper<CabinetBox>()
                        .eq(CabinetBox::getCabinetId, cabinet.getId()));
                for (CabinetBox cabinetBox:list) {
                    CabinetBoxDto cabinetBoxDto = new CabinetBoxDto();
                    BeanPlusUtil.copyProperties(cabinetBox,cabinetBoxDto);
                    cabinetBoxList.add(cabinetBoxDto);
                }
                cabinetDto.setCabinetBoxList(cabinetBoxList);
                cabinetList.add(cabinetDto);
            }
            return cabinetList;
        } else {
            //传递的数据是否正确，不正确抛异常（只接受true、false）
            throw new ServiceException(CabinetExceptionEnum.PARAMETER_ERROR);
        }
    }


    /**
     * 通过单警柜id查询单个单警柜及其箱门信息
     *
     * @param req
     * @return
     */
    @Override
    public CabinetDto showOneCabinet(CabinetReq req) {
        //查询单警柜信息
        Cabinet one = getOne(new LambdaQueryWrapper<Cabinet>()
                .eq(ObjectUtil.isNotEmpty(req.getId()), Cabinet::getId, req.getId()));
        if (ObjectUtil.isNull(one)){
            throw new ServiceException(CabinetExceptionEnum.CABINET_ISNOT_EXISTS);
        }
        //查询单警柜的箱门信息
        List<CabinetBox> list = cabinetBoxService.list(new LambdaQueryWrapper<CabinetBox>()
                .eq(ObjectUtil.isNotEmpty(req.getId()), CabinetBox::getCabinetId, req.getId()));
        List<CabinetBoxDto> boxList=new ArrayList<>();
        for (CabinetBox cabinetBox: list) {
            CabinetBoxDto cabinetBoxDto = new CabinetBoxDto();
            BeanPlusUtil.copyProperties(cabinetBox,cabinetBoxDto);
            boxList.add(cabinetBoxDto);
        }
        //将单警柜的信息和它的箱门信息返回
        CabinetDto cabinetDto = new CabinetDto();
        BeanPlusUtil.copyProperties(one,cabinetDto);
        cabinetDto.setCabinetBoxList(boxList);
        return cabinetDto;
    }

    /**
     * 修改单警柜信息
     * 新增箱数
     * @param req
     * @return
     */
    @Override
    public boolean updateCabinetInfo(UpdateCabinetReq req) {
        //查询传入的组织机构id是否存在
        PubOrg puborg = pubOrgService.getOne(new LambdaQueryWrapper<PubOrg>()
                .eq(ObjectUtil.isNotEmpty(req.getOrgId()),PubOrg::getOrgId,req.getOrgId()));
        if (ObjectUtil.isEmpty(puborg)) {
            //抛出组织机构不存在异常
            throw new ServiceException(PubOrgExceptionEnum.PUBORG_NOT_EXIST);
        }
        //查询是否有重复的单警柜编号
        List<Cabinet> list = this.list(new LambdaQueryWrapper<Cabinet>()
                .eq(ObjectUtil.isNotEmpty(req.getCabinetNum()),Cabinet::getCabinetNum,req.getCabinetNum()));
        if (list.size()>0) {
            //判断是否是本身，如果是则不抛出异常(根据单警柜id进行比较)
            Cabinet cabinet = list.get(0);
            if (!cabinet.getId().equals(req.getId())){
                //抛出单警柜重复异常
                throw new ServiceException(CabinetExceptionEnum.CABINETID_IS_EXISTS);
            }

        }
        Cabinet cabinet = new Cabinet();
        BeanPlusUtil.copyProperties(req, cabinet);
        return this.updateById(cabinet);
    }

    /**
     * 箱门绑定人员
     * 箱门id-->人员
     * @param req
     * @return
     */
    @Override
    public boolean boxBindPolice(CabinetBoxReq req) {
        //通过箱门id查询出箱门信息
        CabinetBox one = cabinetBoxService.getOne(new LambdaQueryWrapper<CabinetBox>()
                .eq(ObjectUtil.isNotEmpty(req.getId()), CabinetBox::getId, req.getId()));
        if (ObjectUtil.isEmpty(one)){
            //箱门id不存在
            throw new ServiceException(CabinetExceptionEnum.CABINETBOX_ISNOT_EXISTS);
        }
        //获取箱门的主柜id
        String cabinetId = one.getCabinetId();
        //通过主柜id获取机构id
        Cabinet one1 = getOne(new LambdaQueryWrapper<Cabinet>()
                .eq(ObjectUtil.isNotEmpty(cabinetId), Cabinet::getId,cabinetId));
        if (ObjectUtil.isEmpty(one1)){
            //单警柜不存在异常
            throw new ServiceException(CabinetExceptionEnum.CABINET_ISNOT_EXISTS);
        }
        long orgId = one1.getOrgId();
        //通过警员id获取警员所在的机构id
        Policeman one2 = policemanService.getOne(new LambdaQueryWrapper<Policeman>()
                .eq(ObjectUtil.isNotEmpty(req.getPoliceId()), Policeman::getId, req.getPoliceId()));
        if (ObjectUtil.isEmpty(one2)){
            //警员不存在异常
            throw new ServiceException(PolicemanExceptionEnum.POLICEMAN_NOT_EXIST);
        }
        Long orgId1 = one2.getOrgId();
        //判断两个机构id是否相同，相同则可以绑定，不相同则绑定失败
        if (!(orgId1==orgId)){
            return false;
        }
        one2.setCabinetBoxId(one.getId());
        return policemanService.updateById(one2);
    }

    @Override
    public ResponseResult getCabinetByOrgId(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("orgId"), "orgId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, e.getMessage());
        }

        // 根据组织机构获取该组织机构下所有单警柜
        List<Map<String,Object>> allCabinet = new ArrayList<>();
        allCabinet = cabinetMapper.getCabinetByOrgId(msg.get("orgId").toString());

        // 遍历allCabinet
        for (Map<String,Object> oneCabinet:allCabinet){
            String cabinetId = oneCabinet.get("id").toString();
            // 根据单警柜id获取箱号信息
            List<Map<String,Object>> allBox = new ArrayList<>();
            allBox = cabinetBoxMapper.getBoxMsg(cabinetId);
            oneCabinet.put("allBoxMsg",allBox);
        }

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS, allCabinet);
    }

    /**
     * 修改单警柜箱门状态
     * @param req
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean ChangeCabinetState(UpdateCabinetReq req) {
        //查询单警柜是否存在
        Cabinet cabinet = getOne(new LambdaQueryWrapper<Cabinet>()
                .eq(Cabinet::getId, req.getId()));
        if (ObjectUtil.isNull(cabinet)){
            throw new ServiceException(CabinetExceptionEnum.CABINET_ISNOT_EXISTS);
        }
        List<UpdateCabinetBoxReq> cabinetBoxList = req.getCabinetBoxList();
        List<CabinetBox> list =new ArrayList<>();
        for (UpdateCabinetBoxReq updateCabinet:cabinetBoxList) {
            CabinetBox cabinetBox = new CabinetBox();
            BeanPlusUtil.copyProperties(updateCabinet,cabinetBox);
            list.add(cabinetBox);
        }
        return cabinetBoxService.updateBatchById(list);
    }

    @Override
    public Long SearchOrgId(String id) {
        Cabinet one = getOne(new LambdaQueryWrapper<Cabinet>().eq(Cabinet::getId, id));
        if (ObjectUtil.isNull(one)){
            throw new ServiceException(CabinetExceptionEnum.CABINET_ISNOT_EXISTS);
        }
        return one.getOrgId();
    }


    //查询机构id是否存在
    private LambdaQueryWrapper<PubOrg> PubOrgWrapper(long orgId) {
        LambdaQueryWrapper<PubOrg> wrapper = new LambdaQueryWrapper<>();
        //查询全部
        if (ObjectUtil.isEmpty(orgId)) {
            return wrapper;
        }
        //查询机构id是否存在
        wrapper.eq(ObjectUtil.isNotEmpty(orgId),PubOrg::getOrgId,orgId);
        return wrapper;
    }
}