package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.dto.PoliceDto;
import com.junmp.jyzb.api.bean.dto.PolicemanDto;
import com.junmp.jyzb.api.bean.query.PolicemanReq;
import com.junmp.jyzb.api.bean.req.UpdatePolicemanReq;
import com.junmp.jyzb.entity.Policeman;
import com.junmp.jyzb.utils.ResponseResult;

import java.util.List;
import java.util.Map;

public interface PolicemanService extends IService<Policeman> {

    //添加警员
    String AddPoliceman(UpdatePolicemanReq req);


    //获取单个警员信息
    PolicemanDto GetOnePolice(PolicemanReq req);


    //删除警员
    boolean DeletePolice(UpdatePolicemanReq req);


    //修改警员信息
    boolean UpdatePolice(UpdatePolicemanReq req);

    List<String> getAllPoliceId(Map<String, Object> orgId);

    List<String> getAllPoliceIdByCabinet(Map<String, Object> cabinetId);


    boolean AddFaceInfo(PolicemanReq req);


    //修改警员状态
    boolean ChangePoliceState(UpdatePolicemanReq req);

    //List<Map<String, Object>> getAllPoliceman(List<String> allPoliceId);

    ResponseResult getAllPoliceman(Map<String, Object> orgId);

    //通过组织机构id查询警员列表
    PoliceDto GetAllPolicemanList(Long orgId);


    //根据单警柜id查询警员列表
    PoliceDto GetPoliceData(String id);

    boolean UpdateFaceInfo(UpdatePolicemanReq req);

    Policeman SearchFaceInfo(PolicemanReq req);



    boolean PoliceBindUser(PolicemanReq req);

    boolean PoliceBindBox(PolicemanReq req);


}
