package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-LogDetail")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_log_detail")
public class LogDetail implements Serializable {
    /**
     * 出入库明细ID
     */
    @ApiModelProperty(value = "出入库明细ID")
    private Integer id;

    /**
     * 物资id
     */
    @ApiModelProperty(value = "物资id")
    @TableField("inverntory_id")
    private String inverntoryId;

    /**
     * 出入库汇总ID
     */
    @ApiModelProperty(value = "出入库汇总ID")
    @TableField("summary_id")
    private Integer summaryId;

    /**
     * 单据ID
     */
    @ApiModelProperty(value = "单据ID")
    @TableField("order_main_id")
    private String orderId;

    /**
     * EPC信息
     */
    @ApiModelProperty(value = "EPC信息")
    private String epc;

    /**
     * 装备名称
     */
    @ApiModelProperty(value = "装备名称")
    @TableField("equipment_name")
    private String equipmentName;

    /**
     * 装备号型
     */
    @ApiModelProperty(value = "装备号型")
    @TableField("equipment_size")
    private String equipmentSize;

    /**
     * 供应商
     */
    @ApiModelProperty(value = "供应商")
    @TableField("equipment_supplier")
    private String equipmentSupplier;

    /**
     * 装备类型:0单件/1装备包
     */
    @ApiModelProperty(value = "装备类型:0单件/1装备包")
    @TableField("equipment_type")
    private Integer equipmentType;

    /**
     * 状态，0正常/1异常
     */
    @ApiModelProperty(value = "状态，0正常/1异常")
    @TableField("error_state")
    private Integer errorState;

    /**
     * 备注信息
     */
    @ApiModelProperty(value = "备注信息")
    private String note;

    /**
     * 业务类型
     */
    @ApiModelProperty(value = "业务类型")
    @TableField("bussiness_type")
    private String bussinessType;

    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 更新人员
     */
    @TableField(value = "update_user", fill = FieldFill.INSERT)
    private String updateUser;

    /**
     * 创建人员
     */
    @TableField(value = "create_user", fill = FieldFill.UPDATE)
    private String createUser;

    /**
     * 照片信息
     */
    @ApiModelProperty(value = "照片信息")
    private String picture;

    /**
     * 作业设备：0手持机 1单警柜 2通道）
     */
    @ApiModelProperty(value = "业务类型")
    @TableField("device_type")
    private Integer deviceType;

    private static final long serialVersionUID = 1L;
}