package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.query.ProductReq;
import com.junmp.jyzb.doc.ProductDoc;
import com.junmp.jyzb.entity.Product;
import com.junmp.jyzb.service.ProductService;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 16:25
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@RestController
@Slf4j
@RequestMapping("/api")
public class ProductController implements ProductDoc {

    @Resource
    private ProductService productService;

    @PostMapping(path = "/product", name = "新增产品")
    @Override
    public ApiRes<Boolean> addProduct(@RequestBody @Validated(ProductReq.add.class) ProductReq req) {
        return ApiRes.success(productService.addProduct(req));
    }

    @PutMapping(path = "/product", name = "编辑产品")
    @Override
    public ApiRes<Boolean> editProduct(@RequestBody @Validated(ProductReq.edit.class) ProductReq req) {
        return ApiRes.success(productService.editProduct(req));
    }

    @GetMapping(path = "/product", name = "产品列表")
    @Override
    public ApiRes<List<Product>> list(ProductReq req) {
        return ApiRes.success(productService.findList(req));
    }


    @DeleteMapping(path = "/product", name = "删除产品")
    @Override
    public ApiRes<Boolean> delProduct(@RequestBody @Validated(ProductReq.delete.class)ProductReq req) {
        return ApiRes.success(productService.del(req));
    }


    @GetMapping(path = "/product/page", name = "产品分页")
    @Override
    public ApiRes<PageResult<Product>> page(ProductReq req) {
        return ApiRes.success(productService.findPage(req));
    }
}
