package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.InventoryDto;
import com.junmp.jyzb.api.bean.query.InventoryReq;
import com.junmp.jyzb.api.bean.query.InventorySumReq;
import com.junmp.jyzb.entity.InventorySummary;
import com.junmp.jyzb.service.InventoryService;
import com.junmp.jyzb.service.InventorySummaryService;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/Inventory")
@Api(tags = "库存模块")
public class InventoryController {
    @Resource
    public InventoryService inventoryService;
    @Resource
    public InventorySummaryService inventorySummaryService;

    @PostMapping("/GetEquipmentInfo")
    @ApiOperation("根据组织机构查询库存信息")
    public ApiRes<PageResult<InventorySummary>> getEquipmentInfo(@RequestBody InventorySumReq req) {
        return ApiRes.success(inventorySummaryService.getEquipmentInfo(req));
    }

    @PostMapping("/SetInventoryMsg")
    @ApiOperation("填充汇总表信息")
    public ResponseResult setInventoryMsg() {
        ResponseResult returnMsg = inventoryService.setInventoryMsg();
        return returnMsg;
    }

    @PostMapping("/GetInventoryList")
    @ApiOperation("查询库存汇总信息")
    public ResponseResult getInventoryList(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = inventoryService.getInventoryList(msg);
        return returnMsg;
    }

    @PostMapping("/GetDetail")
    @ApiOperation("查询库存明细信息")
    public ApiRes<InventoryDto> getDetail(@RequestBody InventoryReq req) {
        return   ApiRes.success(inventoryService.getInventoryDetail(req));
    }
    @PostMapping("/getEquipmentInfo")
    @ApiOperation("查询库存明细信息")
    public ResponseResult getEquipmentInfo(@RequestBody Map<String, Object> msg) {
        ResponseResult returnMsg = inventoryService.getEquipmentInfo(msg);
        return  returnMsg;
    }

    @PostMapping("/UpdateInventoryNum")
    @ApiOperation("手动重置库存数量信息")
    public ResponseResult updateInventoryNum(@RequestBody Map<String,Object> msg){
        ResponseResult returnMsg = inventoryService.updateInventoryNum(msg);
        return  returnMsg;
    }

    @PostMapping("/GetInventoryByOrgId")
    @ApiOperation("查询组织机构拥有装备")
    public ResponseResult getInventoryByOrgId(@RequestBody Map<String,Object> msg){
        ResponseResult returnMsg = inventoryService.getInventoryByOrgId(msg);
        return  returnMsg;
    }

    @PostMapping("/GetInventoryDevelop")
    @ApiOperation("获取装备明细表所有信息")
    public ResponseResult getInventoryDevelop() {
        ResponseResult returnMsg = inventoryService.getInventoryDevelop();
        return returnMsg;
    }

    @PostMapping("/InvertoryBindBox")
    @ApiOperation("装备绑定箱门")
    public ResponseResult InvertoryBindBox(@RequestBody Map<String,Object> msg){
        ResponseResult returnMsg = inventoryService.InvertoryBindBox(msg);
        return returnMsg;
    }
}
