package com.junmp.jyzb.api.bean.query;

import cn.hutool.core.date.DateTime;
import com.junmp.v2.common.bean.request.BaseRequest;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.validator.api.validators.unique.TableUniqueValue;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
@Data
@EqualsAndHashCode(callSuper = true)
public class InventoryReq extends BaseRequest {


    private String ID;
    /**
     * 装备包ID
     */
    private String packageId;

    /**
     * 装备类型ID
     */
    private String typeId;
    /**
     * 装备号型ID
     */
    private String sizeId;
    /**
     * 装备号型
     */
    private String sizeName;
    /**
     * 供应商
     */
    private String supplierName;
    /**
     * 供应商ID
     */
    private String supplierId;

    /**
     * 部门ID
     */
    private long departmentId;

    /**
     * 货架位置
     */
    private String shelfId;

    /**
     * epc
     */
    private String epc;

    /**
     * 组织机构ID
     */
    private String orgId;

    /**
     * 物资状态
     */
    private String state;

    /**
     * 业务状态
     */
    private String bussiness_state;

    /**
     * 位置状态
     */
    private String locationState;


    /**
     * 生产日期
     */
    private DateTime productionDate;



    /**
     * 位置类型
     */
    private String locationType;

    /**
     * 位置ID
     */
    private String locationId ;
    /**
     * 是否遗失
     */
    private int lostFlag ;
}
