package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-Cabinet")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_cabinet")
public class Cabinet implements Serializable {
    /**
     * 单警柜ID
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID )
    @ApiModelProperty(value = "单警柜ID")
    private String id;

    /**
     * 单警柜编号
     */
    @ApiModelProperty(value = "单警柜编号")
    @TableField("cabinet_num")
    private String cabinetNum;
    /**
     * 单警柜名称
     */
    @ApiModelProperty(value = "单警柜名称")
    private String name;

    /**
     * 新版本组织机构号
     */
    @ApiModelProperty(value = "新版本组织机构号")
    @TableField("org_id_int")
    private Long orgId;


    /**
     * 部门id
     */
    @ApiModelProperty(value = "部门id")
    @TableField("department_id")
    private Integer departmentId;
    /**
     * 位置信息
     */
    @ApiModelProperty(value = "位置信息")
    private String location;

    /**
     * 单警柜当前状态，0正常，1异常
     */
    @ApiModelProperty(value = "单警柜当前状态，0正常，1异常")
    private Integer state;

    /**
     * 装备总数
     */
    @ApiModelProperty(value = "装备总数")
    private Integer sum;

    /**
     * 在库装备总数
     */
    @ApiModelProperty(value = "在库装备总数")
    @TableField("in_sum")
    private Integer inSum;

    /**
     * 出库装备总数
     */
    @ApiModelProperty(value = "出库装备总数")
    @TableField("out_sum")
    private Integer outSum;

    /**
     * 库存总价
     */
    @ApiModelProperty(value = "库存总价")
    @TableField("price_total")
    private BigDecimal priceTotal;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @TableField(value="create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    @TableField(value = "update_time")
    private Date updateTime;

    /**
     * 新增人员
     */
    @ApiModelProperty(value = "新增人员")
    @TableField("create_user")
    private String createUser;

    /**
     * 更新人员
     */
    @ApiModelProperty(value = "更新人员")
    @TableField("update_user")
    private String updateUser;

    /**
     * 箱数
     */
    @ApiModelProperty(value = "箱数")
    private Integer num;


    private static final long serialVersionUID = 1L;
}