package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @TableName vie_equipment_count_summary
 */
@TableName(value ="vie_equipment_count_summary")
@Data
public class EquipmentCountSummary implements Serializable {
    /**
     * id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 
     */
    @TableField(value = "valuekey")
    private String valuekey;

    /**
     * 组织机构id
     */
    @TableField(value = "org_id_int")
    private Long orgId;

    /**
     * 组织机构编码
     */
    @TableField(value = "org_code")
    private String orgCode;

    /**
     * 组织机构名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 父id
     */
    @TableField(value = "parent_id")
    private Integer parentId;

    /**
     * 组织机构简称
     */
    @TableField(value = "org_name_short")
    private String orgNameShort;

    /**
     * 统计类型（年year，月month）
     */
    @TableField(value = "sum_type")
    private String sumType;

    /**
     * 年
     */
    @TableField(value = "year")
    private Integer year;

    /**
     * 月
     */
    @TableField(value = "month")
    private Integer month;

    /**
     * 使用次数
     */
    @TableField(value = "use_count")
    private Integer useCount;

    /**
     * 维修次数
     */
    @TableField(value = "fix_count")
    private Integer fixCount;

    /**
     * 号型id
     */
    @TableField(value = "size_id")
    private String sizeId;

    /**
     * 号型名称
     */
    @TableField(value = "size_name")
    private String sizeName;

    /**
     * 类型id
     */
    @TableField(value = "type_id")
    private String typeId;

    /**
     * 类型名称
     */
    @TableField(value = "type_name")
    private String typeName;

    /**
     * 装备总数
     */
    @TableField(value = "number")
    private Integer number;

    /**
     * 更新时间
     */
    @TableField(value = "update_time")
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;


}