package com.junmp.jyzb.task;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.junmp.jyzb.api.util.GenCodeUtil;
import com.junmp.jyzb.entity.Company;
import com.junmp.jyzb.entity.Inventory;
import com.junmp.jyzb.entity.ProductSku;
import com.junmp.jyzb.mapper.ExpireMapper;
import com.junmp.jyzb.mapper.MsgMapper;
import com.junmp.jyzb.service.InventoryService;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.job.api.JobAction;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;


/**
* @Author: Zhaojw
* @Description: 过期物资消息提醒
* @DateTime: 2023/7/14 16:25
* @Params:
* @Return
*/
@Slf4j
@Component
public class InvExpireMsg implements JobAction {

    @Resource
    private ExpireMapper ExpireMapper;
    @Resource
    private InventoryService inventoryService;

    @Override
    public void action() {
        LambdaQueryWrapper<Inventory> wrapper = new LambdaQueryWrapper<>();
        // 分页参数
        int pageSize = 1000; // 每页记录数，可以根据需求调整
        int currentPage = 1; // 当前页数

        //所有待判断的物资
        wrapper.eq( Inventory::getTermState, 0);
        long termCount= inventoryService.count(wrapper);

        if (termCount>0)
        {
            // 分页查询
            while ((currentPage - 1) * pageSize < termCount) {
                processPageData( currentPage, pageSize);
                currentPage++;
        }

        }

    }

    // 处理每页数据
    private void processPageData(long pageSize, long currentPage)
    {

        LocalDate localdate =LocalDate.now();
        // 使用LambdaQueryWrapper构建查询条件
        LambdaQueryWrapper<Inventory> wrapper = Wrappers.lambdaQuery();
        wrapper.eq( Inventory::getTermState, 0);
        wrapper.apply("production_date <= DATE_SUB({0}, INTERVAL warranty_period DAY)", localdate);
        //获取过质保期的物资信息
        List<Inventory> page= inventoryService.page(PageFactory.getDefaultPage(pageSize,currentPage),wrapper).getRecords();
        page.forEach(o->o.setTermState(1));
        inventoryService.saveOrUpdateBatch(page);


//        Page<Inventory> page = inventoryService.page(PageFactory.getDefaultPage(), wrapper)
    }


}
