package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.req.ProductReq;
import com.junmp.jyzb.api.exception.enums.ProductExceptionEnum;
import com.junmp.jyzb.beanReq.PolicemanFingerReq;
import com.junmp.jyzb.entity.PoliceFinger;
import com.junmp.jyzb.entity.Product;
import com.junmp.jyzb.exception.enums.PolicemanFingerExceptionEnum;
import com.junmp.jyzb.mapper.ProductMapper;
import com.junmp.jyzb.service.PoliceFingerService;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.PoliceFingerMapper;

import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class PoliceFingerServiceImpl extends ServiceImpl<PoliceFingerMapper, PoliceFinger> implements PoliceFingerService {

    @Resource
    private PoliceFingerMapper policeFingerMapper;

    @Override
    public List<Map<String, Object>> getFingersByUserId(String userId) {
        return policeFingerMapper.getFingersByUserId(userId);
    }

    //新增指纹信息
    @Override
    public boolean addFingerInfo(PolicemanFingerReq req) {
        PoliceFinger policeFinger = new PoliceFinger();
        BeanPlusUtil.copyProperties(req, policeFinger);
        //创建时间
        policeFinger.setCreateTime(DateTimeUtil.getCurrentDateTime());
        //更新时间
        policeFinger.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        return this.save(policeFinger);
    }

    //修改指纹信息
    @Override
    public boolean updateFingerInfo(PolicemanFingerReq req) {
        PoliceFinger policeFinger = this.queryPolicemanFinger(req);
        BeanPlusUtil.copyProperties(req,policeFinger);
        //更新时间
        policeFinger.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        return this.updateById(policeFinger);
    }

    //查询指纹信息
    @Override
    public List<PoliceFinger> searchFingerInfo(PolicemanFingerReq req) {
        LambdaQueryWrapper<PoliceFinger> wrapper = createWrapper(req);
        return this.list(wrapper);
    }


    //    删除指纹信息
    @Override
    public boolean deleteFinger(PolicemanFingerReq req) {
        this.removeById(req.getId());
        return true;
    }

    /**
     * 分页查询
     * @param req
     * @return
     */
    @Override
    public PageResult<PoliceFinger> findPage(PolicemanFingerReq req) {
        LambdaQueryWrapper<PoliceFinger> wrapper = createWrapper(req);
        Page<PoliceFinger> page = this.page(PageFactory.getDefaultPage(), wrapper);
        return PageResultFactory.createPageResult(page);
    }

    //添加指纹时判断指纹是否存在，如果存在则抛出异常
    //异常信息为：指纹信息已经存在
    private PoliceFinger queryPolicemanFinger(PolicemanFingerReq req) {
        PoliceFinger policeFinger = this.getById(req);
        if (ObjectUtil.isNull(policeFinger)) {
            throw new ServiceException(PolicemanFingerExceptionEnum.POLICEMAN_FINGER_EXCEPTION_ENUM);
        }
        return policeFinger;
    }

    //查询的各种条件信息
    private LambdaQueryWrapper<PoliceFinger> createWrapper(PolicemanFingerReq req) {
        LambdaQueryWrapper<PoliceFinger> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据业务编码查询
        //警员id
        wrapper.like(ObjectUtil.isNotEmpty(req.getPoliceId()), PoliceFinger::getPoliceId, req.getPoliceId());
        //根据企业名称模糊查询
        //指纹名称
        wrapper.like(ObjectUtil.isNotEmpty(req.getName()), PoliceFinger::getName, req.getName());
        //指纹信息
        wrapper.like(ObjectUtil.isNotEmpty(req.getFingerInfo()), PoliceFinger::getFingerInfo, req.getFingerInfo());
        wrapper.orderByDesc(PoliceFinger::getUpdateTime);
        return wrapper;
    }
}
