package com.junmp.jyzb.service.impl;

import com.junmp.jyzb.mapper.MsgMapper;
import com.junmp.jyzb.service.MsgService;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.jyzb.utils.ReturnMsg;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
public class MsgServiceImpl implements MsgService {
    @Resource
    private MsgMapper msgMapper;

    @Override
    public ResponseResult getMsg(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("orgId"), "orgId不能为空");
            checkNotBlank(msg.get("tableName"), "tableName不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        String orgId = msg.get("orgId").toString();
        String tableName = msg.get("tableName").toString();

        List<Map<String,Object>> returnMsg =  msgMapper.getMsg(orgId,tableName);
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,returnMsg);
    }

    @Override
    public ResponseResult getUserMsg(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("orgId"), "orgId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        String orgId = msg.get("orgId").toString();

        List<Map<String,Object>> returnMsg =  msgMapper.getUserMsg(orgId);
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,returnMsg);
    }
}
