package com.junmp.jyzb.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.junmp.jyzb.entity.CabinetBox;
import com.junmp.jyzb.mapper.CabinetBoxMapper;
import com.junmp.jyzb.service.CabinetBoxService;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.jyzb.utils.ReturnMsg;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
public class CabinetBoxServiceImpl implements CabinetBoxService {

    @Resource
    private CabinetBoxMapper cabinetBoxMapper;

    @Override
    public List<Map<String, Object>> getAllBoxMsg(String id) {
        return cabinetBoxMapper.getBoxMsg(id);
    }

    /**
         * @author lxh
         * @description 通过cabinetId获取箱门信息列表
         * @since 2023/7/18 22:20
         * @param
         * @return
         **/
    @Override
    public ResponseResult getCabinetBoxInfo(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("cabinetId"), "cabinetId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }
        List<CabinetBox> cabinetBoxList = cabinetBoxMapper.selectList(new LambdaQueryWrapper<CabinetBox>()
                .eq(CabinetBox::getCabinetId, msg.get("cabinetId")));
        return new ResponseResult<>(HttpStatus.SUCCESS,"操作成功",cabinetBoxList);
    }
}
