package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-Supplier")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_supplier")
public class Supplier implements Serializable {
    /**
     * 供应商ID
     */
    @TableField(value = "id")
    private String id;

    /**
     * 供应商名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 供应商短码
     */
    @TableField(value = "code")
    private String code;

    /**
     * 简称
     */
    @TableField(value = "short_name")
    private String shortName;

    /**
     * 联系人
     */
    @TableField(value = "contacts")
    private String contacts;

    /**
     * 联系电话
     */
    @TableField(value = "phone")
    private String phone;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 创建人员
     */
    @TableField(value = "create_user")
    private String createUser;

    /**
     * 最后更新时间
     */
    @TableField(value = "update_time")
    private Date updateTime;

    /**
     * 更新人ID
     */
    @TableField(value = "update_user")
    private String updateUser;

    /**
     * 1为启用，0为禁用
     */
    @TableField(value = "state")
    private Integer state;

    private static final long serialVersionUID = 1L;
}