package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value="com-junmp-jyzb-domain-Shelf")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_shelf")
public class Shelf implements Serializable {
    /**
     * 货架id
     */
    @ApiModelProperty(value="货架id")
    private String shelfId;

    /**
     * 货架名称
     */
    @ApiModelProperty(value="货架名称")
    private String shelfName;

    /**
     * 编码
     */
    @ApiModelProperty(value="编码")
    private String code;

    /**
     * 货架类型Normal:普通货架Smart:智能货架
     */
    @ApiModelProperty(value="货架类型Normal:普通货架Smart:智能货架")
    private String type;

    /**
     * 仓库
     */
    @ApiModelProperty(value="仓库")
    private String warehouseId;

    /**
     * 货架层数
     */
    @ApiModelProperty(value="货架层数")
    private Integer shelfRows;

    /**
     * 单层货架列数
     */
    @ApiModelProperty(value="单层货架列数")
    private Integer shelfColumns;

    /**
     * 货架排数（智能货架多货架拼接）
     */
    @ApiModelProperty(value="货架排数（智能货架多货架拼接）")
    private Integer shelfRanges;

    /**
     * 智能货架地址
     */
    @ApiModelProperty(value="智能货架地址")
    private String url;

    /**
     * 型号
     */
    @ApiModelProperty(value="型号")
    private String sizeInfo;

    @ApiModelProperty(value="")
    private Date createTime;

    @ApiModelProperty(value="")
    private Date updateTime;

    @ApiModelProperty(value="")
    private String createUser;

    @ApiModelProperty(value="")
    private String updateUser;

    private static final long serialVersionUID = 1L;
}