package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-LogSummary")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_log_summary")
public class LogSummary implements Serializable {
    /**
     * 出入库汇总ID
     */
    @ApiModelProperty(value = "出入库汇总ID")
    private Integer id;

    /**
     * 组织机构ID
     */
    @ApiModelProperty(value = "组织机构ID")
    @TableField("error_state")
    private String orgId;

    /**
     * 组织机构名称
     */
    @ApiModelProperty(value = "组织机构名称")
    @TableField("error_state")
    private String orgName;

    /**
     * 单据id
     */
    @ApiModelProperty(value = "单据id")
    @TableField("order_main_id")
    private String orderMainId;

    /**
     * 存储ID
     */
    @ApiModelProperty(value = "存储ID")
    @TableField("location_id")
    private String locationId;

    /**
     * 存储名称：XX仓库，XX单警柜
     */
    @ApiModelProperty(value = "存储名称")
    @TableField("location_name")
    private String locationName;

    /**
     * 设备标识
     */
    @ApiModelProperty(value = "设备标识")
    private String device;

    /**
     * 出入设备:0手持机/1单警柜/2通道
     */
    @ApiModelProperty(value = "出入设备:0手持机/1单警柜/2通道")
    @TableField("device_type")
    private Integer deviceType;

    /**
     * 操作时间
     */
    @ApiModelProperty(value = "操作时间")
    @TableField("use_time")
    private Date useTime;

    /**
     * 业务类型
     */
    @ApiModelProperty(value = "业务类型")
    @TableField("bussiness_type")
    private String bussinessType;
    /**
     * 操作人员姓名
     */
    @ApiModelProperty(value = "操作人员姓名")
    @TableField("user_name")
    private String userName;

    /**
     * 出入库类型:0出库/1入库
     */
    @ApiModelProperty(value = "出入库类型:0出库/1入库")
    @TableField("out_in_state")
    private Integer outInState;

    /**
     * 照片信息
     */
    @ApiModelProperty(value = "照片信息")
    private String picture;

    /**
     * 装备记录集合，警棍、盾牌
     */
    @ApiModelProperty(value = "装备记录集合")
    @TableField("equipment_List")
    private String equipmentList;

    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 更新人员
     */
    @TableField(value = "update_user", fill = FieldFill.INSERT)
    private String updateUser;

    /**
     * 创建人员
     */
    @TableField(value = "create_user", fill = FieldFill.UPDATE)
    private String createUser;

    private static final long serialVersionUID = 1L;
}