package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-CabinetBox")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_cabinet_box")
public class CabinetBox implements Serializable {
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    private String id;

    /**
     * 主柜ID
     */
    @ApiModelProperty(value = "主柜ID")
    @TableField("cabinet_id")
    private String cabinetId;

    /**
     * 箱号
     */
    @ApiModelProperty(value = "箱号")
    private Integer num;

    /**
     * 异常状态:1正常/0异常
     */
    @ApiModelProperty(value = "异常状态:1正常/0异常")
    private Integer state;

    /**
     * 异常原因
     */
    @ApiModelProperty(value = "异常原因")
    @TableField("error_msg")
    private String errorMsg;

    /**
     * 使用日志存储位置信息
     */
    @ApiModelProperty(value = "使用日志存储位置信息")
    @TableField("log_map")
    private String logMap;

    private static final long serialVersionUID = 1L;
}