package com.junmp.jyzb.doc;

import com.junmp.jyzb.api.bean.req.CompanyReq;
import com.junmp.jyzb.entity.Company;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 10:47
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Api(value = "企业管理", tags = "企业管理接口")
public interface CompanyDoc {

    /**
     * 新增企业
     */
    @ApiOperation(value = "新增企业", tags = "企业管理接口")
    ApiRes<Boolean> addBiz(CompanyReq req);

    /**
     * 更新企业
     */
    @ApiOperation(value = "更新企业", tags = "企业管理接口")
    ApiRes<Boolean> editBiz(CompanyReq req);


    /**
     * 获取所有企业
     */
    @ApiOperation(value = "获取所有企业", tags = "企业管理接口")
    ApiRes<List<Company>> list(CompanyReq req);

    /**
     * 删除企业
     */
    @ApiOperation(value = "删除企业",tags = "企业管理接口")
    ApiRes<Boolean> delBiz(CompanyReq req);


    /**
     * 企业信息分页
     */
    @ApiOperation(value = "分页企业信息", tags = "企业管理接口")
    ApiRes<PageResult<Company>> page(CompanyReq req);
}
