package com.junmp.jyzb.controller;

import cn.hutool.core.util.ObjectUtil;
import com.junmp.jyzb.api.bean.req.ProductSkuReq;
import com.junmp.jyzb.api.bean.vo.ProductSkuVo;
import com.junmp.jyzb.doc.ProductSkuDoc;
import com.junmp.jyzb.entity.ProductSku;
import com.junmp.jyzb.service.ProductSkuService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.exception.enums.DefaultBizExceptionEnum;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.page.PageResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 17:59
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@RestController
@Slf4j
@RequestMapping("/api")
public class ProductSkuController implements ProductSkuDoc {

    @Resource
    private ProductSkuService productSkuService;


    @PostMapping(path = "/spec", name = "新增号型")
    @Override
    public ApiRes<Boolean> addProductSku(@RequestBody @Validated(ProductSkuReq.add.class) ProductSkuReq req) {
        try {
            productSkuService.addProductSku(req);
            return ApiRes.success();
        } catch (ServiceException ex) {
            log.error("新增号型异常>>" + ex.getMessage());
            return ApiRes.failure(DefaultBizExceptionEnum.SYS_RUNTIME_ERROR);
        }
    }

    @PutMapping(path = "/spec", name = "编辑号型")
    @Override
    public ApiRes<Boolean> editProductSku(@RequestBody @Validated(ProductSkuReq.edit.class)ProductSkuReq req) {
        return ApiRes.success(productSkuService.editProductSku(req));
    }

    @DeleteMapping(path = "/spec", name = "删除号型")
    @Override
    public ApiRes<Boolean> del(@RequestBody @Validated(ValidationApi.delete.class)ProductSkuReq req) {
        return ApiRes.success(productSkuService.del(req));
    }


    @GetMapping(path = "/spec/page", name = "分页号型")
    @Override
    public ApiRes<PageResult<ProductSku>> page(ProductSkuReq req) {
        return ApiRes.success(productSkuService.findPage(req));
    }


    @GetMapping(path = "/spec/getByProduct", name = "获取指定产品号型列表")
    @Override
    public ApiRes<List<ProductSkuVo>> listByProduct(ProductSkuReq req) {
        if (ObjectUtil.isNotNull(req) && ObjectUtil.isNotNull(req.getProductId())) {
            List<ProductSku> list = productSkuService.findList(req);
            return ApiRes.success(BeanPlusUtil.toBeanList(list, ProductSkuVo.class));
        } else {
            return ApiRes.failure("产品编号不能为空");
        }
    }
}
