package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.BaseRequest;
import com.junmp.v2.validator.api.validators.unique.TableUniqueValue;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 10:56
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class CompanyReq extends BaseRequest {

    @NotNull(message = "企业编号不能为空", groups = {edit.class, delete.class, detail.class})
    private Long bizId;

    @NotBlank(message = "企业编码不能为空", groups = {edit.class})
    @TableUniqueValue(
            message = "编码重复",
            groups = {edit.class},
            tableName = "biz_company",
            columnName = "biz_code",
            idFieldName = "biz_id")
    private String bizCode;

    /**
     * 单位类型
     */
    private String bizType;

    /**
     * 名称
     */
    private String name;

    /**
     * 简称
     */
    private String shortName;

    /**
     * 备注
     */
    private String remark;
}
