package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.query.PolicemanFingerReq;
import com.junmp.jyzb.api.bean.req.UpdatePoliceFingerReq;
import com.junmp.jyzb.doc.PolicemanFingerDoc;
import com.junmp.jyzb.entity.PoliceFinger;
import com.junmp.jyzb.service.PoliceFingerService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/PolicemanFinger")
@Api(tags = "[基础信息]警员指纹信息模块")
public class PolicemanFingerController implements PolicemanFingerDoc {

    @Resource
    PoliceFingerService policeFingerService;

    @PostMapping(path="/AddFingerInfo",name="添加指纹信息#logType=30")
    @ApiOperation("添加指纹信息")
    public ApiRes<Integer> addFingerInfo(@RequestBody @Validated(ValidationApi.add.class) UpdatePoliceFingerReq req) {
        return ApiRes.success(policeFingerService.addFingerInfo(req)) ;

    }

    @PostMapping(path="/UpdateFingerInfo",name="修改指纹信息#logType=30")
    @ApiOperation("修改指纹信息")
    public ApiRes<Boolean> updateFingerInfo(@RequestBody @Validated(ValidationApi.edit.class) UpdatePoliceFingerReq req) {
        return ApiRes.success(policeFingerService.updateFingerInfo(req)) ;

    }
    @PostMapping(path="/insertOrUpdateFingerInfo",name="新增或者修改指纹信息#logType=30")
    @ApiOperation("新增或者修改指纹信息")
    public ApiRes<Boolean> insertOrUpdateFingerInfo(@RequestBody  @Validated(ValidationApi.detail.class) UpdatePoliceFingerReq req) {
        return ApiRes.success(policeFingerService.insertOrUpdateFingerInfo(req)) ;

    }



    @PostMapping(path="/searchFingerInfo",name="查找指纹信息#enable")
    @ApiOperation("查找指纹信息")
    public ApiRes<List<PoliceFinger>> searchFingerInfo(@RequestBody @Validated(ValidationApi.edit.class) PolicemanFingerReq req) {
        return ApiRes.success(policeFingerService.searchFingerInfo(req));
    }

    @PostMapping(path="/DeleteFingerInfo",name="删除警员指纹信息#logType=30")
    @ApiOperation("删除警员指纹信息")
    public ApiRes<Boolean> deletePoliceFinger(@RequestBody @Validated(ValidationApi.delete.class) UpdatePoliceFingerReq req) {
        return ApiRes.success(policeFingerService.deleteFinger(req));
    }

    @ApiOperation("/分页信息")
    @PostMapping(path="/GetInvInfoByEpc",name="根据EPC列表获取装备信息#enable")
    @GetMapping(path = "/page", name = "指纹信息分页")
    public ApiRes<PageResult<PoliceFinger>> page(PolicemanFingerReq req) {
        return ApiRes.success(policeFingerService.findPage(req));
    }
}
