package com.junmp.jyzb.api.bean.query;

import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

@Data
@EqualsAndHashCode(callSuper = true)
public class ShelfReq extends BaseRequest {

    @NotBlank(message = "货架id不能为空",groups = {edit.class})
    private String shelfId;

    private String areaId;

    private String shelfName;

    private String code;

    private String type;

    @NotBlank(message = "仓库id不能为空",groups = {detail.class})
    private String warehouseId;

    private Integer shelfRows;

    private Integer shelfColumns;

    private Integer shelfRanges;

    private String url;

    private String sizeInfo;

}
