package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.junmp.jyzb.api.bean.dto.TjDto.FinalTjOrgPriceDto;
import com.junmp.jyzb.api.bean.dto.TjDto.TjOrgPriceDto;
import com.junmp.jyzb.entity.PriceSumSummary;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface PriceSumSummaryMapper extends BaseMapper<PriceSumSummary> {


    /**
     * 存储过程-月初金额数量统计
     */
    void  MonthStart ();

    /**
     * 存储过程-月末金额数量统计
     */
    void  MonthEnd ();

    /**
     * 存储过程-月末差值计算统计
     */
    void  MonthDifference ();

    TjOrgPriceDto TjOrgPrice(@Param("orgId") String orgId,
                                   @Param("year") Integer year,
                                   @Param("typeIdsList") List<String> typeIdsList,
                                   @Param("sizeNameList")List<String> sizeNameList);

    List<TjOrgPriceDto> TjOrgPriceDetail(@Param("orgId") Long orgId,
                                         @Param("year") Integer year,
                                         @Param("typeIdsList")List<String> typeIdsList,
                                         @Param("sizeNameList") List<String> sizeNameList,
                                         @Param("pageNo")Long pageNo, @Param("pageSize") Long pageSize);

    int TjOrgPriceDetailSum(@Param("orgId") Long orgId,
                            @Param("year") Integer year,
                            @Param("typeIdsList")List<String> typeIdsList,
                            @Param("sizeNameList") List<String> sizeNameList);

//    FinalTjOrgPriceDto TjOrgPriceSum(@Param("orgId") Long orgId,@Param("year") Integer year,
//                                     @Param("typeIdsList") List<String> typeIdsList,
//                                     @Param("sizeNameList") List<String> sizeNameList);

    void setSizeName(@Param("sizeId") String id, @Param("sizeName") String name);

    void setTypeName(@Param("typeId") String id, @Param("typeName") String name);

    TjOrgPriceDto TjOrgPriceLeve4(@Param("orgId") Long orgId,
                                  @Param("year") Integer year,
                                  @Param("typeIdsList") List<String> typeIdsList,
                                  @Param("sizeNameList")List<String> sizeNameList,
                                  @Param("levelFlag")Integer levelFlag);

    List<TjOrgPriceDto> TjOrgPriceTotalNum(@Param("orgId") Long orgId,
                                           @Param("year") Integer year,
                                           @Param("typeIdsList") List<String> typeIdsList,
                                           @Param("sizeNameList")List<String> sizeNameList,
                                           @Param("levelNum")Integer levelNum);
}
