package com.junmp.jyzb.task;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.junmp.jyzb.api.util.GenCodeUtil;
import com.junmp.jyzb.entity.Company;
import com.junmp.jyzb.entity.Inventory;
import com.junmp.jyzb.entity.InventorySummary;
import com.junmp.jyzb.entity.ProductSku;
import com.junmp.jyzb.mapper.ExpireMapper;
import com.junmp.jyzb.mapper.MsgMapper;
import com.junmp.jyzb.service.InventoryService;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.dict.entity.SysDictItem;
import com.junmp.v2.dict.service.SysDictItemService;
import com.junmp.v2.job.api.JobAction;
import com.junmp.v2.message.api.MessageApi;
import com.junmp.v2.message.api.bean.req.MessageReq;
import com.junmp.v2.message.api.bean.req.MessageSendReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;


/**
* @Author: Zhaojw
* @Description: 过期物资消息提醒
* @DateTime: 2023/7/14 16:25
* @Params:
* @Return
*/
@Slf4j
@Component
public class InvExpireMsg implements JobAction {


    @Resource
    private InventoryService inventoryService;

    @Resource
    private MessageApi messageApi;

    @Resource
    private SysDictItemService sysDictItemService;

    @Override
    public void action() {
        LambdaQueryWrapper<Inventory> wrapper = new LambdaQueryWrapper<>();
        // 分页参数
        int pageSize = 1000; // 每页记录数，可以根据需求调整
        int currentPage = 1; // 当前页数

        //所有待判断的物资
        wrapper.eq( Inventory::getTermState, 0);
        //获取未超期的物资数量
        long termCount= inventoryService.count(wrapper);
        List<Inventory> list=new ArrayList<>();
        if (termCount>0) {
            // 分页查询
            while ((currentPage - 1) * pageSize < termCount) {
                List<Inventory> inventoryList = processPageData(currentPage, pageSize);
                currentPage++;
                list.addAll(inventoryList);
            }
        }
        //超期物资查询出来之后，将超期物资进行消息推送提醒
        //直接对list进行处理操作推送消息即可
        for (Inventory inventory:list) {
            MessageSendReq sendReq = new MessageSendReq();
            sendReq.setSendUserId("1000");
            sendReq.setReceiveUserIds("1000");
            sendReq.setMsgTitle("物资过质保期");
            //设置业务类型
            SysDictItem one = sysDictItemService.getOne(new LambdaQueryWrapper<SysDictItem>()
                    .eq(SysDictItem::getDictItemId, "1698969778501099522"));
            sendReq.setBizType(one.getItemValue());
            sendReq.setMsgContent("仓库下的装备的物资已经过质保期");
            sendReq.setPriority("0");
            sendReq.setSendTime(DateTime.now());
            messageApi.sendMessage(sendReq);
        }
        messageApi.queryCount(new MessageReq());
        /*推送发送未读数量*/
        List<Long> userIdList=new ArrayList<>();
        userIdList.add(1000L);
        for(Long userId :userIdList){
            MessageReq req1 = new MessageReq();
            req1.setReadFlag(0);
            req1.setReceiveUserId(userId);
            Integer count1 = messageApi.queryCount(req1);
            messageApi.pushMsgToUser(String.valueOf(userId),count1);
        }
    }

    // 处理每页数据
    private List<Inventory> processPageData(long pageSize, long currentPage)
    {
        LocalDate localdate =LocalDate.now();
        // 使用LambdaQueryWrapper构建查询条件
        LambdaQueryWrapper<Inventory> wrapper = Wrappers.lambdaQuery();
        wrapper.eq( Inventory::getTermState, 0);
        //如果 生产日期 < 当前日期减去质保数,表示该装备已经超过质保期
        wrapper.apply("production_date <= DATE_SUB({0}, INTERVAL warranty_period DAY)", localdate);
        //获取过质保期的物资信息
        List<Inventory> page= inventoryService.page(PageFactory.getDefaultPage(pageSize,currentPage),wrapper).getRecords();
        page.forEach(o->o.setTermState(1));
        inventoryService.saveOrUpdateBatch(page);
        return page;

//        Page<Inventory> page = inventoryService.page(PageFactory.getDefaultPage(), wrapper)
    }


}
