package com.junmp.jyzb.service.impl;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.ProductTagDto;
import com.junmp.jyzb.api.bean.dto.SimpleTagDto;

import com.junmp.jyzb.api.bean.query.ProductTagReq;
import com.junmp.jyzb.api.exception.enums.ProductExceptionEnum;

import com.junmp.jyzb.entity.ProductTag;
import com.junmp.jyzb.mapper.ProductTagMapper;
import com.junmp.jyzb.service.ProductTagService;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 09:36
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Service
@Slf4j
public class ProductTagServiceImpl extends ServiceImpl<ProductTagMapper, ProductTag> implements ProductTagService {


    @Override
    public boolean addTagInfo(ProductTagReq req) {
        ProductTag tag = new ProductTag();
        BeanPlusUtil.copyProperties(req, tag);

        tag.setProduceTime(new Date());
        tag.setHasChecked(false);
        return this.save(tag);
    }

    @Override
    public boolean editTagInfo(ProductTagReq req) {
        return false;
    }

    @Override
    public boolean del(ProductTagReq req) {
        return false;
    }

    @Override
    public ProductTag checkTagUid(ProductTagReq req) {
        //1-查找TagUid是否绑定
        ProductTag tag = findByUid(req.getTagUid());
        if (ObjectUtil.isNull(tag)) {
            //未绑定
            SimpleTagDto dto = baseMapper.getInitTagInfo(req.getBatchId());
            if (ObjectUtil.isNull(dto)) {
                throw new ServiceException(ProductExceptionEnum.TAG_INFO_INIT_DONE);
            }
            tag = new ProductTag();
            tag.setTagId(dto.getTagId());
            tag.setProductCode(dto.getProductCode());
            return tag;
        } else {
            //已绑定
            //2-验证批次是否一致
            if (StrUtil.equalsIgnoreCase(String.valueOf(req.getBatchId()),
                    String.valueOf(tag.getBatchId()))) {
                return tag;
            } else {
                //抛出异常，标签已经绑定了
                throw new ServiceException(ProductExceptionEnum.TAG_INFO_HAD_BINDING);
            }
        }
    }


    @Override
    public ProductTag findByUid(String tagUid) {
        ProductTagReq tmp = new ProductTagReq();
        tmp.setTagUid(tagUid);

        LambdaQueryWrapper<ProductTag> wp = createWrapper(tmp);
        List<ProductTag> list = list(wp);
        if (CollectionUtil.isNotEmpty(list)) {
            return list.get(0);
        } else {
            return null;
        }
    }

    @Override
    public ProductTagDto getTagInfo(Long tagId) {
        ProductTagDto dto = baseMapper.getTagInfoByTagId(tagId);
        if (ObjectUtil.isNull(dto)) {
            throw new ServiceException(ProductExceptionEnum.TAG_INFO_NOT_EXISTS);
        }
        return dto;
    }

    @Override
    public List<ProductTag> findList(ProductTagReq req) {
        LambdaQueryWrapper<ProductTag> wp = createWrapper(req);
        return this.list(wp);
    }

    @Override
    public PageResult<ProductTag> findPage(ProductTagReq req) {
        LambdaQueryWrapper<ProductTag> wrapper = createWrapper(req);
        Page<ProductTag> page = this.page(PageFactory.getDefaultPage(req.getPageNo(),req.getPageSize()), wrapper);
        return PageResultFactory.createPageResult(page);
    }


    private LambdaQueryWrapper<ProductTag> createWrapper(ProductTagReq req) {
        LambdaQueryWrapper<ProductTag> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据业务编码查询
        wrapper.eq(ObjectUtil.isNotEmpty(req.getProductCode()), ProductTag::getProductCode, req.getProductCode());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getTagUid()), ProductTag::getTagUid, req.getTagUid());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getBatchId()), ProductTag::getBatchId, req.getBatchId());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getTagId()), ProductTag::getTagId, req.getTagId());


        wrapper.eq(ProductTag::getHasInit, true);
        wrapper.orderByDesc(ProductTag::getCheckTime);
        return wrapper;
    }
}
