package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.OrderDetailDto;
import com.junmp.jyzb.api.bean.dto.OrderDto;
import com.junmp.jyzb.api.bean.dto.OrderMainDto;
import com.junmp.jyzb.api.bean.query.OrderDetailReq;
import com.junmp.jyzb.api.bean.query.OrderMainReq;
import com.junmp.jyzb.api.bean.query.OrderUploadReq;
import com.junmp.jyzb.api.bean.req.DetailListReq;
import com.junmp.jyzb.api.bean.req.UpdateOrderReq;
import com.junmp.jyzb.api.exception.enums.CabinetExceptionEnum;
import com.junmp.jyzb.api.exception.enums.OrderExceptionEnum;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.mapper.OrderMainMapper;
import com.junmp.jyzb.service.*;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import com.junmp.v2.dict.entity.SysDictItem;
import com.junmp.v2.dict.service.SysDictItemService;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.core.*;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.*;
import java.util.stream.Collectors;


@Service
public class OrderMainServiceImpl extends ServiceImpl<OrderMainMapper, OrderMain> implements OrderMainService {

    @Resource
    private OrderDetailService orderDetailService;
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Resource
    private RabbitAdmin rabbitAdmin;

    @Resource
    private OrderNumService orderNumService;

    @Resource
    private PubOrgService pubOrgService;

    @Resource
    private OrderMainMapper orderMainMapper;

    @Resource
    private SysDictItemService sysDictItemService;

    @Resource
    private OrderLogService orderLogService;



    //新增任务单
    @Transactional(rollbackFor = Exception.class)
    @Override
    public List<String> AddOrder(UpdateOrderReq req) {
        //存放主单据和子单据，便于返回
        List<String> list=new ArrayList<>();
        OrderMain order = new OrderMain();
        BeanPlusUtil.copyProperties(req, order);
        //设置单据单号（订单号）
        OrderNum orderNum = setOrderCode(req);
        String codeValue=String.format("%04d",orderNum.getNum());
        order.setOrderCode(orderNum.getBussinessType()+"-"+orderNum.getYear()+"-"+orderNum.getMonth()+"-"+orderNum.getDay()+"-"+codeValue);
        //设置总价格和应出入库数量
        //设置id
        String id=UUID.randomUUID().toString();
        order.setId(id);
        Integer sumNum=0;
        BigDecimal priceTotal=new BigDecimal(0);
        List<OrderDetail> detailList = new ArrayList<>();
        //通过遍历批量保存详细信息
        for (DetailListReq listReq:req.getDetailList()) {
            OrderDetail detail=new OrderDetail();
            BeanPlusUtil.copyProperties(listReq, detail);
            detail.setOrderId(order.getId());
            //设置单据类型
            detail.setType(order.getOrderType());
            //将数量和价格进行累加
            sumNum += detail.getPlanNum();
            priceTotal = priceTotal.add(BigDecimal.valueOf(detail.getPlanNum()).multiply(detail.getPrice())) ;
            detail.setCreateTime(DateTimeUtil.getCurrentDateTime());
            detailList.add(detail);
        }
        orderDetailService.saveBatch(detailList);
       //设置总价格和总数量
        order.setPrice(priceTotal);
        order.setInventoryQuantity(sumNum);
        order.setCreateTime(DateTimeUtil.getCurrentDateTime());
        //保存
        this.save(order);
        list.add(order.getId());
        for (OrderDetail orderDetail:detailList) {
            list.add(Long.toString(orderDetail.getId()));
        }
        return list;
    }


    //设置单据单号（并且对order_num表进行新增或者更新）
    public OrderNum setOrderCode(UpdateOrderReq req){
        //设置采购单号，需要先判断该组织机构的采购单号是否存在，如果存在则将数量进行增加，如果不存在则新增一条对应的数据
        OrderNum orderNum = new OrderNum();
        //获取年,月，日，获取业务出入状态，获取组织机构id，获取业务类型
        orderNum.setYear(LocalDateTime.now().getYear());
        orderNum.setMonth(LocalDateTime.now().getMonth().getValue());
        orderNum.setDay(LocalDateTime.now().getDayOfMonth());
        //将业务类型转为中文简写
        String itemValue = sysDictItemService.getOne(new LambdaQueryWrapper<SysDictItem>()
                .eq(SysDictItem::getItemText, req.getBussinessType())).getItemValue();
        orderNum.setBussinessType(itemValue);
        //出入业务状态
        orderNum.setOutInType(req.getOrderType());
        //判断是出库还是入库，出库为发物单位，入库为收物单位
        OrderNum one = new OrderNum();
        if (req.getOrderType().equals("in")){
            orderNum.setEndOrgId(Long.valueOf(req.getEndOrgId()));
            one = orderNumService.getOne(new LambdaQueryWrapper<OrderNum>()
                    .eq(OrderNum::getEndOrgId, orderNum.getEndOrgId())
                    .eq(OrderNum::getBussinessType, orderNum.getBussinessType())
                    .eq(OrderNum::getYear, orderNum.getYear())
                    .eq(OrderNum::getMonth, orderNum.getMonth())
                    .eq(OrderNum::getDay, orderNum.getDay())
                    .eq(OrderNum::getOutInType, orderNum.getOutInType()));
        }else {
            orderNum.setStartOrgId(Long.valueOf(req.getStartOrgId()));
            one = orderNumService.getOne(new LambdaQueryWrapper<OrderNum>()
                    .eq(OrderNum::getStartOrgId, orderNum.getStartOrgId())
                    .eq(OrderNum::getBussinessType,orderNum.getBussinessType())
                    .eq(OrderNum::getYear, orderNum.getYear())
                    .eq(OrderNum::getMonth, orderNum.getMonth())
                    .eq(OrderNum::getDay, orderNum.getDay())
                    .eq(OrderNum::getOutInType, orderNum.getOutInType()));
        }


        //设置num的数量
        if (ObjectUtil.isNull(one)){
            orderNum.setNum(1);
            orderNumService.save(orderNum);
            return orderNum;
        }else {
            one.setNum(one.getNum()+1);
            orderNumService.updateById(one);
            return one;
        }

    }


    //新增默认审核通过的任务单
    @Transactional(rollbackFor = Exception.class)
    @Override
    public String AddFinishOrder(UpdateOrderReq req) {
        //添加到数据库中
        String orderId = AddOrder(req).get(0);
        //将完成的任务单直接推送到消息队列rabbitmq中（需要判断是入库单还是出库单，入库单传发物单位id，出库单传收物单位id）
        //方法1：一个交换机，一个队列。通过中间对象，object存储对象，type表标识
//        if(req.getOrderType().equals("in")){
//            rabbitTemplate.convertAndSend("OrderExchange","OrderRouting",new MessageWrapper(req,req.getStartOrgId()));
//        }else {
//            rabbitTemplate.convertAndSend("OrderExchange","OrderRouting",new MessageWrapper(req,req.getEndOrgId()));
//        }
        //方法2：一个交换机，多个队列。动态创建队列
        String exchangeName="orderExchange";
        //需要判断是入库单还是出库单，入库单传收物单位id，出库单传发物单位id
        if(req.getOrderType().equals("in")){
            Queue queue=new Queue(req.getEndOrgId(),true,false,false);
            Exchange exchange = new DirectExchange(exchangeName, true, false);
            rabbitAdmin.declareQueue(queue);
            rabbitAdmin.declareExchange(exchange);
            rabbitAdmin.declareBinding(BindingBuilder.bind(queue).to(exchange).with(req.getEndOrgId()).noargs());
            rabbitTemplate.convertAndSend(exchangeName, req.getEndOrgId(), req);

        }else {
            Queue queue = new Queue(req.getStartOrgId(), true, false, false);
            Exchange exchange = new DirectExchange(exchangeName, true, false);
            rabbitAdmin.declareQueue(queue);
            rabbitAdmin.declareExchange(exchange);
            rabbitAdmin.declareBinding(BindingBuilder.bind(queue).to(exchange).with(req.getStartOrgId()).noargs());
            rabbitTemplate.convertAndSend(exchangeName, req.getStartOrgId(), req);
        }
        return orderId;
    }


    //更新任务单（进入工作流中之后不能进行更改）
    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean  updateOrder(UpdateOrderReq req) {
        OrderMain order = orderMainExist(req.getId());
        if (!order.getExamineState().equals("none"))
        {
            throw new ServiceException(OrderExceptionEnum.ORDER_CAN_NOT_UPDATE);
        }
        List<OrderDetail> list= orderDetailService.QueryList(req.getId());
        //idSet中存放的是存在数据库中的任务单中的orderDetail中的id（原始的工作单中的数据id）
        Set<Long> idSet =new HashSet<>();
        for (OrderDetail orderDetail:list){
            idSet.add(orderDetail.getId());
        }
        //将该任务单的所有id转换为String,并添加到updateList中，用来判断删除或者修改新增的是否存在
        //判断删除列表是否为空，如果不为空则进行批量删除
        if (ObjectUtil.isNotNull(req.getDeleteList())&& ObjectUtil.isNotEmpty(req.getDeleteList())) {
            //判断传递的list Id是否存在，如果不存在则抛出异常
            for (Long s:req.getDeleteList()){
                if (idSet.contains(s)){
                    //将要删除的装备价格和数据进行查询出来，并别对任务单的总数量和总价格进行更改
                    OrderDetail one = orderDetailService.getOne(new LambdaQueryWrapper<OrderDetail>()
                            .eq(OrderDetail::getOrderId, s));
                    order.setPrice(order.getPrice().subtract(one.getPrice().multiply(BigDecimal.valueOf(one.getPlanNum()))));
                    order.setInventoryQuantity(order.getInventoryQuantity() - one.getPlanNum());

                }else {
                    throw new ServiceException(CabinetExceptionEnum.PARAMETER_ERROR);
                }
            }
            orderDetailService.removeBatchByIds(req.getDeleteList());
        }
        //对detaillist进行处理
        List<OrderDetail> addList = new ArrayList<>();//新增的
        List<OrderDetail> updateList = new ArrayList<>();//更新
        for (DetailListReq detailListReq :req.getDetailList()) {
            //判断是否存在，存在则进行修改
            if (idSet.contains(detailListReq.getId())){
                OrderDetail one = orderDetailService.getOne(new LambdaQueryWrapper<OrderDetail>()
                        .eq(OrderDetail::getId, detailListReq.getId()));
                BeanPlusUtil.copyProperties(detailListReq,one);
                one.setType(req.getOrderType());
                //判断数量和价格是否有变动，如果有变动，则将order的总价和总数量进行更新操作，否则不变
                if (one.getPlanNum().equals(detailListReq.getPlanNum()) && one.getPrice().compareTo(detailListReq.getPrice())!=0){
                    order.setPrice(order.getPrice().subtract(one.getPrice().multiply(BigDecimal.valueOf(one.getPlanNum())))
                            .add(detailListReq.getPrice().multiply(BigDecimal.valueOf(detailListReq.getPlanNum()))));
                    order.setInventoryQuantity(order.getInventoryQuantity() - one.getPlanNum()+ detailListReq.getPlanNum());
                }
                one.setUpdateTime(DateTimeUtil.getCurrentDateTime());
                updateList.add(one);
            }else {
                //否则判断id是否为空或者错误，如果为空则添加，不为空则抛出异常
                if (ObjectUtil.isNull(detailListReq.getId()) || ObjectUtil.isEmpty(detailListReq.getId())){
                    OrderDetail detail=new OrderDetail();
                    BeanPlusUtil.copyProperties(detailListReq, detail);
                    detail.setOrderId(req.getId());
                    detail.setType(req.getOrderType());
                    //将数量和价格进行相加处理
                    order.setPrice(order.getPrice().add(detailListReq.getPrice().multiply(BigDecimal.valueOf(detailListReq.getPlanNum()))));
                    order.setInventoryQuantity(order.getInventoryQuantity() + detailListReq.getPlanNum());
                    detail.setUpdateTime(DateTimeUtil.getCurrentDateTime());
                    addList.add(detail);
                }else {
                    throw new ServiceException(CabinetExceptionEnum.PARAMETER_ERROR);
                }

            }
        }
        orderDetailService.updateBatchById(updateList);
        orderDetailService.saveBatch(addList);
        BeanPlusUtil.copyProperties(req,order);
        return this.updateById(order);
    }
    public boolean hasCommonElements(List<?> list1, List<?> list2) {
        for (Object item1 : list1) {
            if (list2.contains(item1)) {
                return true; // 找到相同值
            }
        }
        return false; // 没有相同值
    }

    //查询任务列表(根据组织机构id)
    @Override
    public PageResult<OrderMainDto> getOrderPage(OrderMainReq req) {
        Page<OrderMain> page = new Page<>();
        //排序字段处理，将驼峰改成和数据库同步的字段名
        String column = req.getColumn();
        String order = req.getOrder();
        if (ObjectUtil.isNotNull(column) && !column.trim().isEmpty()
                && ObjectUtil.isNotNull(order) && !order.trim().isEmpty()){
            req.setColumn(column.replaceAll("[A-Z]", "_$0").toLowerCase());
        }
        //根据查询条件得到单据
        IPage<OrderMain> outOrderPage = orderMainMapper.getOrderPage(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()),req);
        page.setRecords(outOrderPage.getRecords());
        page.setTotal(outOrderPage.getTotal());

        List<OrderMainDto> orderMainDtoList = page.getRecords().stream().map(orderMain -> {
            OrderMainDto orderMainDto = new OrderMainDto();
            BeanPlusUtil.copyProperties(orderMain,orderMainDto);
            return orderMainDto;
        }).collect(Collectors.toList());
        Page<OrderMainDto> page1 = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        page1.setTotal(page.getTotal());
        page1.setRecords(orderMainDtoList);
        return PageResultFactory.createPageResult(page1);
    }



    //根据任务单id查看业务明细
    @Override
    public OrderDto GetDetailById(OrderMainReq req) {
        //判断任务单是否存在
        OrderMain orderMain = orderMainExist(req.getId());
        OrderDto orderDto = new OrderDto();
        BeanPlusUtil.copyProperties(orderMain,orderDto);
        //将详细信息存入列表属性中
        //通过任务单id查询对应的详细信息
        List<OrderDetail> list = orderDetailService.list(new LambdaQueryWrapper<OrderDetail>()
                .eq(OrderDetail::getOrderId, req.getId()));
        List<OrderDetailDto> orderDetailDtoList=new ArrayList<>();
        for (OrderDetail orderDetail:list) {
            OrderDetailDto orderDetailDto = new OrderDetailDto();
            BeanPlusUtil.copyProperties(orderDetail,orderDetailDto);
            orderDetailDtoList.add(orderDetailDto);
        }
        orderDto.setDetailList(orderDetailDtoList);
        return orderDto;
    }

    //单据状态上报
    @Override
    public boolean PushState(OrderUploadReq req) {
        OrderMain orderMain = orderMainExist(req.getId());
        //获取单据的出入库，获取发物单位id或者收物单位id
        String orderType = orderMain.getOrderType();
        String exchangeName="OrderStateExchange";
        //推送到rabbitmq中去
        if (orderType.equals("in")){
            Long endOrgId = orderMain.getEndOrgId();
            Queue queue=new Queue(Long.toString(endOrgId),true,false,false);
            Exchange exchange = new DirectExchange(exchangeName, true, false);
            rabbitAdmin.declareQueue(queue);
            rabbitAdmin.declareExchange(exchange);
            rabbitAdmin.declareBinding(BindingBuilder.bind(queue).to(exchange).with(Long.toString(endOrgId)).noargs());
            rabbitTemplate.convertAndSend(exchangeName, Long.toString(endOrgId), req);

        }else {
            Long startOrgId = orderMain.getStartOrgId();
            Queue queue = new Queue(Long.toString(startOrgId), true, false, false);
            Exchange exchange = new DirectExchange(exchangeName, true, false);
            rabbitAdmin.declareQueue(queue);
            rabbitAdmin.declareExchange(exchange);
            rabbitAdmin.declareBinding(BindingBuilder.bind(queue).to(exchange).with(Long.toString(startOrgId)).noargs());
            rabbitTemplate.convertAndSend(exchangeName, Long.toString(startOrgId), req);
        }
        return true;
    }

    //记账
    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean Accounting(OrderMainReq req) {
        //判断传递的订单主id是否存在
        OrderMain orderMain = orderMainExist(req.getId());
        //记账子单据不能传空
        if (req.getChildrenOrder().size()==0){
            throw new ServiceException(OrderExceptionEnum.ORDERDETAIL_ISNOT_NULL);
        }
        Set<Long> collect = req.getChildrenOrder().stream().map(OrderDetailReq::getId).collect(Collectors.toSet());
        //前端传递的子单数据
        List<OrderDetailReq> reqList = req.getChildrenOrder();
        //将实际数量进行添加
        Integer actualQuantity=0;
        //将价格进行添加修改
        BigDecimal priceTotal=new BigDecimal(0);
        //获取子单据
        List<OrderDetail> list = orderDetailService.list(new LambdaQueryWrapper<OrderDetail>()
                .eq(OrderDetail::getOrderId,req.getId()));
        Set<Long> existingIds = list.stream()
                .map(OrderDetail::getId)
                .collect(Collectors.toSet());
        //创建记账操作记录并且记录到数据表order_log中
        OrderLog orderLog = new OrderLog();
        orderLog.setOrderId(req.getId());
        StringBuilder stringBuilder = new StringBuilder();
        List<OrderDetail> orderDetailList=new ArrayList<>();
        //比较两个子单id完全一致,判断传递的子单据id在数据库中是否存在，如果不存在则抛出子单据不存在异常
        if (collect.size() == existingIds.size() && collect.containsAll(existingIds) && existingIds.containsAll(collect)){
            for (OrderDetailReq uploadDetailReq : reqList) {
                OrderDetail orderDetail = new OrderDetail();
                BeanPlusUtil.copyProperties(uploadDetailReq,orderDetail);
                //获取修改后的数量并且记录
                if (ObjectUtil.isNotNull(uploadDetailReq.getModifyQuantity())){
                    String log = "将"+uploadDetailReq.getTypeName()+"-"+
                            uploadDetailReq.getSizeName()+"的物资数量从"+uploadDetailReq.getActualNum()+"修改为"+uploadDetailReq.getModifyQuantity()+";";
                    stringBuilder.append(log);
                    //修改单子数量数据
                    orderDetail.setActualNum(uploadDetailReq.getModifyQuantity());
                    orderDetail.setUpdateTime(DateTimeUtil.getCurrentDateTime());
                    orderDetailList.add(orderDetail);
                    actualQuantity+=uploadDetailReq.getModifyQuantity();
                    priceTotal=priceTotal.add(BigDecimal.valueOf(uploadDetailReq.getModifyQuantity())).multiply(uploadDetailReq.getPrice());
                }else {
                    actualQuantity+=uploadDetailReq.getActualNum();
                    priceTotal=priceTotal.add(BigDecimal.valueOf(uploadDetailReq.getActualNum())).multiply(uploadDetailReq.getPrice());
                }

            }
        }else {
            throw new ServiceException(OrderExceptionEnum.ORDERDETAIL_ERROR);
        }
        orderLog.setHistoryMsg(stringBuilder.toString());
        if (req.getOrderType().equals("in")){
            orderLog.setOrgId(req.getEndOrgId());
        }else {
            orderLog.setOrgId(req.getStartOrgId());
        }
        orderLog.setCreateTime(DateTimeUtil.getCurrentDateTime());
        //将记账记录保存
        orderLogService.save(orderLog);
        //批量更新子单据数量
        if (orderDetailList.size()!=0){
            orderDetailService.updateBatchById(orderDetailList);
        }
        //更新主单据的数量和价格
        orderMain.setActualQuantity(actualQuantity);
        orderMain.setPrice(priceTotal);
        //记账直接将单子结束
        orderMain.setOrderState("finished");
        //修改记账状态，0未记账，1已记账
        orderMain.setManualState(1);
        orderMain.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        //更新主单据
        return updateById(orderMain);
    }


    //判断任务单是否存在
    @Override
    public OrderMain orderMainExist(String id) {
        OrderMain order = this.getById(id);
        if (ObjectUtil.isNull(order)) {
            throw new ServiceException(OrderExceptionEnum.ORDER_NOT_EXIST);
        }
        return order;
    }

    //设置pageNo和pageSize的通用方法
    public Map<String,Long> getPage(Long no,Long size){
        Map<String,Long> map=new HashMap<>();
        long pageSize;
        long pageNo;
        if (ObjectUtil.isNull(no)){
            pageNo = 1L;
        }else {
            pageNo= no;
        }
        if ( ObjectUtil.isNull(size)){
            pageSize = 20L;
        }else {
            pageSize= size;
        }
        map.put("pageNo",pageNo);
        map.put("pageSize",pageSize);
        return map;
    }



    private LambdaQueryWrapper<OrderMain> createWrapper(OrderMainReq req) {
        LambdaQueryWrapper<OrderMain> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //单据状态 ready待入/出库，finished已入/出库，working入/出库中
        wrapper.eq(ObjectUtil.isNotEmpty(req.getOrderState()), OrderMain::getOrderState, req.getOrderState());
        //审核状态:none,未接入审核流，working审批中，finished已完成
        wrapper.eq(ObjectUtil.isNotEmpty(req.getExamineState()), OrderMain::getExamineState, req.getExamineState());
        //业务类型
        wrapper.eq(ObjectUtil.isNotEmpty(req.getBussinessType()), OrderMain::getBussinessType, req.getBussinessType());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        //查询出指定时间内的单据
        String startTime="";
        String endTime="";
        if (req.getStartTime()!=null && !req.getStartTime().trim().isEmpty()){
            startTime=req.getStartTime()+" 00:00:00";
            try {
                wrapper.ge(OrderMain::getCreateTime,dateFormat.parse(startTime));
            } catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if (req.getEndTime()!=null && !req.getEndTime().trim().isEmpty()){
            endTime=req.getEndTime()+" 23:59:59";
            try {
                wrapper.le(OrderMain::getCreateTime,dateFormat.parse(endTime));
            } catch (ParseException e) {
                throw new RuntimeException(e);
            }

        }
        wrapper.orderByDesc(OrderMain::getCreateTime);

        return wrapper;

    }

}
