package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.EquipmentTypeDto;
import com.junmp.jyzb.api.bean.dto.EquipmentTreeDto;
import com.junmp.jyzb.api.bean.query.QueryEquipmentTypeReq;
import com.junmp.jyzb.api.bean.req.UpdateEquipmentTypeReq;
import com.junmp.jyzb.api.exception.JYZBAppException;
import com.junmp.jyzb.api.exception.enums.EquipmentTypeExceptionEnum;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.service.EquipmentTypeService;
import com.junmp.jyzb.service.SupplierService;
import com.junmp.jyzb.service.SupplierTypeService;
import com.junmp.jyzb.utils.*;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.EquipmentTypeMapper;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;


@Service
public class EquipmentTypeServiceImpl extends ServiceImpl<EquipmentTypeMapper, EquipmentType> implements EquipmentTypeService {

    @Resource
    private RedisUtils redisUtils;

    @Resource
    private EquipmentTypeMapper equipmentTypeMapper;


    @Resource
    private SupplierService supplierService;
    @Resource
    private SupplierTypeService supplierTypeService;
    private static final String REDIS_TYPE = "Type_";


    //查询出类别表中数据的所有装备信息（入库时调用）
    public List<EquipmentTypeDto> getEquipmentList(QueryEquipmentTypeReq req) {
        List<EquipmentType> list = list(new LambdaQueryWrapper<EquipmentType>()
                .eq(EquipmentType::getType,req.getType()));
        List<EquipmentTypeDto> collect = list.stream().map(equipmentType -> {
            EquipmentTypeDto org = new EquipmentTypeDto();
            BeanPlusUtil.copyProperties(equipmentType, org);
            return org;
        }).collect(Collectors.toList());
        return collect;
  }

    @Transactional
    @Override
    public String addEquipment(UpdateEquipmentTypeReq req) {

        EquipmentType type = new EquipmentType();
        List<String> chekResult = supplierService.CheckSupplierList(req.getSupplierList());
        if (chekResult.size() == 0) {

            //先增加code码
            BeanPlusUtil.copyProperties(req, type);
            EquipmentType parentType = this.getById(req.getParentId());
            int newcode = parentType.getMaxCode() + 1;
            type.setId(String.valueOf(newcode));
            type.setCode(String.valueOf(newcode));

            parentType.setMaxCode(newcode);
            parentType.setCode(String.valueOf(newcode));
            List<SupplierType> supplierType = new ArrayList<>();
            //判断req.getSupplierList()是否为空，如果为空则不进行循环
            if (req.getSupplierList().size()!=0){
                req.getSupplierList().forEach(supply -> {
                            SupplierType st = new SupplierType();
                            st.setId(String.valueOf(UUID.randomUUID()));
                            st.setState(0);
                            st.setSupplierId(supply);
                            st.setTypeId(String.valueOf(newcode));
                            supplierType.add(st);
                        }
                );
                supplierTypeService.saveBatch(supplierType);
            }
            this.updateById(parentType);
            this.save(type);
            return  String.valueOf(newcode);
        } else {
            String msg="以下供应商不存在：" +String.join(",", chekResult);
            throw new JYZBAppException(EquipmentTypeExceptionEnum.SUPPLIER_NOT_EXIST, msg);
        }
    }



    @Override
    public Boolean deleteEquipment(UpdateEquipmentTypeReq req) {
        LambdaQueryWrapper<EquipmentType> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ObjectUtil.isNotEmpty(req.getId()), EquipmentType::getParentId, req.getParentId());
        List<EquipmentType> eqList = list(wrapper);
        if (eqList.size() > 0) {
            throw new ServiceException(EquipmentTypeExceptionEnum.EQUIPMENT_CHILDREN_EXIST);
        } else {
            this.removeById(req.getId());
        }

        return true;
    }
    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean updateEquipment(UpdateEquipmentTypeReq req) {
        EquipmentType type = this.queryEqType(req);

        List<String> chekResult = supplierService.CheckSupplierList(req.getSupplierList());
        if (chekResult.size() == 0) {
            // 先增加code码
            BeanPlusUtil.copyProperties(req, type);

            // 获取当前type对应的所有关联的供应商
            List<SupplierType> currentSupplierList = supplierTypeService.list(new LambdaQueryWrapper<SupplierType>()
                    .eq(SupplierType::getTypeId, type.getId()));

            // 获取当前type对应的所有关联的供应商ID集合
            Set<String> currentSupplierIds = currentSupplierList.stream()
                    .map(SupplierType::getSupplierId)
                    .collect(Collectors.toSet());

            // 获取传入的supplierList中的所有供应商ID集合
            Set<String> newSupplierIds = new HashSet<>(req.getSupplierList());

            // 需要新增的供应商关联数据
            List<SupplierType> supplierTypeToAdd = new ArrayList<>();
            for (String supplierId : newSupplierIds) {
                if (!currentSupplierIds.contains(supplierId)) {
                    SupplierType st = new SupplierType();
                    st.setId(String.valueOf(UUID.randomUUID()));
                    st.setState(0);
                    st.setSupplierId(supplierId);
                    st.setTypeId(String.valueOf(type.getId()));
                    supplierTypeToAdd.add(st);
                }
            }

            // 需要删除的供应商关联数据
            List<SupplierType> supplierTypeToDelete = new ArrayList<>();
            for (SupplierType currentSupplier : currentSupplierList) {
                if (!newSupplierIds.contains(currentSupplier.getSupplierId())) {
                    supplierTypeToDelete.add(currentSupplier);
                }
            }

            // 保存新增的供应商关联数据
            supplierTypeService.saveBatch(supplierTypeToAdd);

            // 删除需要删除的供应商关联数据
            if (!supplierTypeToDelete.isEmpty()) {
                supplierTypeService.removeByIds(supplierTypeToDelete.stream()
                        .map(SupplierType::getId)
                        .collect(Collectors.toList()));
            }
            // 保存type
            return this.updateById(type);
        } else {
            String msg="以下供应商不存在：" +String.join(",", chekResult);
            throw new JYZBAppException(EquipmentTypeExceptionEnum.SUPPLIER_NOT_EXIST, msg);
        }
    }

    private EquipmentType queryEqType(UpdateEquipmentTypeReq req) {
        EquipmentType type = this.getById(req.getId());

        if (ObjectUtil.isNull(type)) {
            throw new ServiceException(EquipmentTypeExceptionEnum.EQUIPMENT_TYPE_NOT_EXIST);
        }
        return type;
    }


    @Override
    public Boolean changeEquipmentState(UpdateEquipmentTypeReq req) {
        EquipmentType equipment = this.getById(req.getId());
        if (equipment != null) {
            equipment.setState(Integer.valueOf(req.getState()));
            return this.updateById(equipment);
        }
        return true;
    }


    //获取单个物资的信息
    @Override
    public EquipmentTypeDto getEquipment(QueryEquipmentTypeReq req) {
        EquipmentTypeDto equipment = new EquipmentTypeDto();
        BeanPlusUtil.copyProperties(this.getById(req.getId()), equipment);
        //获取该物资的供应商id
        List<SupplierType> list = supplierTypeService.list(new LambdaQueryWrapper<SupplierType>()
                .eq(SupplierType::getTypeId, req.getId()));
        List<String> collect = list.stream().map(SupplierType::getSupplierId).distinct().collect(Collectors.toList());
        equipment.setSupplierList(collect);
        return equipment;
    }
    public List<EquipmentTypeDto> getLowType(QueryEquipmentTypeReq req){
        if (ObjectUtil.isEmpty(req.getParentId())) {
            req.setParentId(req.getId());
        }
        if (ObjectUtil.isEmpty(req.getParentId())) {
            req.setParentId("00000000-0000-0000-0000-000000000000");
        }
        LambdaQueryWrapper<EquipmentType> wp= this.createWrapper(req);
        List<EquipmentType> list = this.list(wp);
        List<EquipmentTypeDto> orgs=new ArrayList<>();
        Comparator<EquipmentType> orgComparator = (org1, org2) -> {
            String code1 = org1.getCode();
            String code2 = org2.getCode();

            // 将code字段转换为整数类型进行比较
            try {
                long intValue1 = Long.parseLong(code1);
                long intValue2 = Long.parseLong(code2);
                return Long.compare(intValue1, intValue2);
            } catch (NumberFormatException e) {
                // 如果有不是数字的情况，直接返回字符串比较结果
                return code1.compareTo(code2);
            }
        };
        Collections.sort(list, orgComparator);

        list.forEach(p->{
            EquipmentTypeDto org=new EquipmentTypeDto();
            BeanPlusUtil.copyProperties(p, org);
            //判断是否有下级，如果没有设置为true；
            // 判断是否有子节点
            boolean hasChildren = hasChildren(p.getId());
            org.setIsLeaf(!hasChildren);
            orgs.add(org);
        });
        return orgs;
    }

    // 判断是否有子节点的方法
    private boolean hasChildren(String parentId) {
        LambdaQueryWrapper<EquipmentType> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(EquipmentType::getParentId, parentId);
        Long count = this.count(wrapper);
        return count > 0;
    }

    @Override
    public ResponseResult setTypeParentIds() {
        //清空parent_ids字段
        equipmentTypeMapper.wipeParentIdsData();
        //更新parent_ids字段
        equipmentTypeMapper.setTypeParentIds();
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    //获取整棵type树
    public List<EquipmentTreeDto> GetTypeTree() {
        List<EquipmentType> list = list(new LambdaQueryWrapper<EquipmentType>()
                .ne(EquipmentType::getId, "00000000-0000-0000-0000-000000000000"));
        List<EquipmentTreeDto> dtoList = new ArrayList<>();
        // 构建根节点列表
        List<EquipmentType> rootEntities = new ArrayList<>();
        for (EquipmentType entity : list) {
            if (entity.getParentId().equals("00000000-0000-0000-0000-000000000000")) {
                rootEntities.add(entity);
            }
        }
        // 递归转换为输出类节点
        for (EquipmentType rootEntity : rootEntities) {
            EquipmentTreeDto dto = convertNode(rootEntity, list);
            dtoList.add(dto);
        }
        return dtoList;
    }

    private  EquipmentTreeDto convertNode(EquipmentType entity, List<EquipmentType> entityList) {
        EquipmentTreeDto dto = new EquipmentTreeDto();
        BeanPlusUtil.copyProperties(entity,dto);
        dto.setIsLeaf(true); // 默认为叶子节点
        List<EquipmentTreeDto> children = new ArrayList<>();
        for (EquipmentType childEntity : entityList) {
            if (childEntity.getParentId().equals(entity.getId())) {
                EquipmentTreeDto childDto = convertNode(childEntity, entityList);
                children.add(childDto);
                dto.setIsLeaf(false);  // 存在子节点，当前节点不是叶子节点
            }
        }
        dto.setChildren(children);
        return dto;
    }

    private LambdaQueryWrapper<EquipmentType> createWrapper(QueryEquipmentTypeReq req) {
        LambdaQueryWrapper<EquipmentType> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        wrapper.eq(ObjectUtil.isNotEmpty(req.getParentId()), EquipmentType::getParentId,req.getParentId() );
        // 添加id字段不等于"00000000-0000-0000-0000-000000000000"的判断
        wrapper.ne(EquipmentType::getId, "00000000-0000-0000-0000-000000000000");
        wrapper.eq(ObjectUtil.isNotEmpty(req.getType()), EquipmentType::getType,req.getType() );
            wrapper.orderByDesc(EquipmentType::getCreateTime);
            return wrapper;

    }
}


