package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.dto.OrderDto;
import com.junmp.jyzb.api.bean.dto.OrderMainDto;
import com.junmp.jyzb.api.bean.query.OrderMainReq;
import com.junmp.jyzb.api.bean.query.OrderUploadReq;
import com.junmp.jyzb.api.bean.req.UpdateOrderReq;
import com.junmp.jyzb.entity.OrderMain;
import com.junmp.v2.db.api.page.PageResult;

import java.util.List;
import java.util.Map;

public interface OrderMainService extends IService<OrderMain> {
    List<String> AddOrder(UpdateOrderReq req);
    String AddFinishOrder(UpdateOrderReq req);

    //更新任务单
    Boolean updateOrder(UpdateOrderReq req);


    //判断任务单是否存在
    OrderMain orderMainExist(String id);


    //查询任务列表(根据组织机构id)
    PageResult<OrderMainDto> getOrderPage(OrderMainReq req);

    //根据任务单id查看业务明细
    OrderDto GetDetailById(OrderMainReq req);

    //设置page的pageNo和pageSize的通用方法
    Map<String,Long> getPage(Long no,Long size);

    //单据状态上报
    boolean PushState(OrderUploadReq req);

    //记账
    boolean Accounting(OrderMainReq req);
}
