package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value="com-junmp-jyzb-domain-WarehouseArea")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_warehouse_area")
public class WarehouseArea implements Serializable {
    @TableId(value = "area_id", type = IdType.ASSIGN_UUID)
    private String areaId;

    @TableField("area_name")
    private String areaName;

    @TableField("org_id_int")
    private Long orgId;

    @TableField("warehouse_id")
    private String warehouseId;

    @TableField("photo")
    private String photo;

    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @TableField(value = "update_time", fill = FieldFill.UPDATE)
    private Date updateTime;

    @TableField("create_user")
    private String createUser;

    @TableField("update_user")
    private Date updateUser;

    private static final long serialVersionUID = 1L;
}