package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


@TableName(value ="base_police_equipment")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PoliceEquipment implements Serializable {
    /**
     * 主键
     */
    @TableId(value = "id",type = IdType.AUTO)
    @ApiModelProperty(value = "主键ID")
    private String id;

    /**
     * 警员ID
     */
    @TableField("police_id")
    private String policeId;

    /**
     * 装备号型id
     */
    @TableField("size_id")
    private String sizeId;

    /**
     *装备号型名称
     */
    @TableField("size_name")
    private String sizeName;

    /**
     * 装备类型id
     */
    @TableField("type_id")
    private String typeId;

    /**
     *装备类型名称
     */
    @TableField("type_name")
    private String typeName;

    /**
     * 装备数量
     */
    @TableField("num")
    private Integer num;

    /**
     * 组织机构ID
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private Date updateTime;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private Date createTime;

    private static final long serialVersionUID = 1L;

}